/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.debugkeybind.gui;

import dev.boxadactle.boxlib.gui.config.BConfigList;
import dev.boxadactle.boxlib.gui.config.widget.label.BLabel;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.debugkeybind.DebugKeybindMain;
import dev.boxadactle.debugkeybind.gui.KeybindButton;
import dev.boxadactle.debugkeybind.gui.ResetButton;
import dev.boxadactle.debugkeybind.keybind.DebugKeybind;
import dev.boxadactle.debugkeybind.keybind.DebugKeybinds;
import dev.boxadactle.debugkeybind.keybind.GlobalKeybind;
import dev.boxadactle.debugkeybind.keybind.KeybindConfig;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;

public class KeybindEntry
extends BConfigList.ConfigEntry {
    public DebugKeybind keybind;
    public BLabel label;
    public KeybindButton keybindButton;
    public ResetButton resetButton;
    Runnable globalRefresh;

    public KeybindEntry(DebugKeybind keybind, Function<KeybindEntry, Boolean> onSelect, Runnable refresh) {
        this.label = new BLabel(keybind.getTranslation());
        this.keybindButton = new KeybindButton(keybind, () -> (Boolean)onSelect.apply(this));
        this.resetButton = new ResetButton(keybind, refresh);
        this.keybind = keybind;
        this.refresh();
        this.globalRefresh = refresh;
    }

    public List<? extends AbstractWidget> getWidgets() {
        return List.of(this.label, this.keybindButton, this.resetButton);
    }

    public boolean isInvalid() {
        return false;
    }

    public void updateKey(int code) {
        this.keybindButton.update(code);
        this.refresh();
        this.globalRefresh.run();
    }

    public void resetKey() {
        this.keybindButton.resetKey();
        this.globalRefresh.run();
    }

    public void refresh() {
        this.resetButton.refresh();
        if (this.keybind.isUnbound()) {
            this.keybindButton.updateConflicts(List.of());
            return;
        }
        List<Component> collisions = this.keybind.checkConflicts(DebugKeybinds.toList());
        if (!((KeybindConfig)DebugKeybindMain.CONFIG.get()).requireDebugKey || this.keybind instanceof GlobalKeybind) {
            KeyMapping[] mappings = (KeyMapping[])ClientUtils.getOptions().keyMappings.clone();
            collisions.addAll(this.keybind.checkMinecraftConflicts(List.of(mappings)));
        }
        this.keybindButton.updateConflicts(collisions);
    }

    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean b, float v) {
        int keybindWidth = 75;
        int resetWidth = 50;
        int padding = 2;
        this.label.setX(this.getX() - 25);
        this.label.setY(this.getY());
        this.label.setWidth(this.getWidth() - keybindWidth - resetWidth - padding);
        this.label.render(guiGraphics, mouseX, mouseY, v);
        this.keybindButton.setX(this.getX() + this.getWidth() - keybindWidth - resetWidth - padding);
        this.keybindButton.setY(this.getY());
        this.keybindButton.setWidth(keybindWidth);
        this.keybindButton.render(guiGraphics, mouseX, mouseY, v);
        this.resetButton.setX(this.getX() + this.getWidth() - resetWidth);
        this.resetButton.setY(this.getY());
        this.resetButton.setWidth(resetWidth);
        this.resetButton.render(guiGraphics, mouseX, mouseY, v);
    }
}

