/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.debugkeybind.keybind;

import com.mojang.blaze3d.platform.InputConstants;
import dev.boxadactle.boxlib.keybind.KeybindHelper;
import dev.boxadactle.debugkeybind.keybind.DebugKeybind;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;

public class ActionKeybind
implements DebugKeybind {
    String name;
    String category;
    InputConstants.Key key;
    InputConstants.Key defaultKey;
    InputConstants.Key oDefaultKey;

    public ActionKeybind(String string, int i, String string2) {
        this.name = string;
        this.category = string2;
        this.defaultKey = this.key = InputConstants.Type.KEYSYM.getOrCreate(i);
    }

    public ActionKeybind(String string, int i, String string2, int oDefault) {
        this(string, i, string2);
        this.key = this.oDefaultKey = oDefault != -1 ? InputConstants.Type.KEYSYM.getOrCreate(oDefault) : InputConstants.UNKNOWN;
    }

    public int getRebind() {
        return this.defaultKey.getValue();
    }

    @Override
    public void setToDefault() {
        this.key = this.oDefaultKey != null ? this.oDefaultKey : this.defaultKey;
    }

    @Override
    public InputConstants.Key getDefaultKey() {
        return this.oDefaultKey != null ? this.oDefaultKey : this.defaultKey;
    }

    @Override
    public void setKey(InputConstants.Key key) {
        this.key = key;
    }

    @Override
    public void setKey(int key) {
        this.key = InputConstants.Type.KEYSYM.getOrCreate(key);
    }

    @Override
    public InputConstants.Key getKey() {
        return this.key;
    }

    @Override
    public int getKeyCode() {
        return this.key.getValue();
    }

    @Override
    public int getDefaultKeyCode() {
        return (this.oDefaultKey != null ? this.oDefaultKey : this.defaultKey).getValue();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public boolean isUnbound() {
        return this.key.equals((Object)InputConstants.UNKNOWN);
    }

    @Override
    public Component getTranslation() {
        return Component.translatable((String)this.name);
    }

    @Override
    public boolean isDefault() {
        return this.key.getValue() == (this.oDefaultKey != null ? this.oDefaultKey : this.defaultKey).getValue();
    }

    @Override
    public List<Component> checkConflicts(List<DebugKeybind> keybinds) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (DebugKeybind k : keybinds) {
            if (k.getName().equals(this.name) || k.getKeyCode() != this.getKeyCode()) continue;
            list.add((Component)Component.translatable((String)k.getName()));
        }
        return list;
    }

    @Override
    public List<Component> checkMinecraftConflicts(List<KeyMapping> keyMappings) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (KeyMapping k : keyMappings) {
            if (KeybindHelper.getBoundKey((KeyMapping)k).getValue() != this.getKeyCode()) continue;
            list.add((Component)Component.translatable((String)k.getName()));
        }
        return list;
    }
}

