/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.debugkeybind.mixin;

import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.debugkeybind.keybind.DebugKeybinds;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.options.controls.KeyBindsList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={KeyBindsList.KeyEntry.class})
public class KeyBindsListMixin {
    @Shadow
    @Final
    private KeyMapping key;
    @Shadow
    @Final
    private Button changeButton;
    @Shadow
    private boolean hasCollision;

    @Inject(method={"renderContent"}, at={@At(value="RETURN")})
    private void checkDebugCollisions(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isHovering, float partialTick, CallbackInfo ci) {
        if (this.key.isUnbound()) {
            return;
        }
        List<Component> collisions = DebugKeybinds.getCollisions(this.key);
        if (!collisions.isEmpty()) {
            this.changeButton.setMessage(GuiUtils.colorize((Component)this.changeButton.getMessage(), (int)GuiUtils.RED));
        }
    }

    @Inject(method={"refreshEntry"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyMapping;isUnbound()Z")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void checkDebugCollisions(CallbackInfo ci, MutableComponent mutableComponent) {
        if (this.key.isUnbound()) {
            return;
        }
        List<Component> collisions = DebugKeybinds.getCollisions(this.key);
        if (!collisions.isEmpty()) {
            if (this.hasCollision) {
                mutableComponent.append(", ");
            }
            boolean bl = false;
            this.hasCollision = true;
            for (Component c : collisions) {
                if (bl) {
                    mutableComponent.append(", ");
                }
                bl = true;
                mutableComponent.append(c);
            }
        }
    }
}

