/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.debugkeybind.mixin;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import dev.boxadactle.boxlib.scheduling.Scheduling;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.debugkeybind.DebugKeybindMain;
import dev.boxadactle.debugkeybind.keybind.DebugKeybinds;
import dev.boxadactle.debugkeybind.keybind.KeybindConfig;
import net.minecraft.Util;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={KeyboardHandler.class})
public abstract class KeyboardHandlerMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private long debugCrashKeyTime;
    @Shadow
    private boolean handledDebugKey;

    @Shadow
    protected abstract void debugFeedbackTranslated(String var1);

    @Shadow
    protected abstract boolean handleDebugKeys(KeyEvent var1);

    @Shadow
    protected abstract boolean handleChunkDebugKeys(KeyEvent var1);

    @ModifyConstant(method={"keyPress"}, constant={@Constant(intValue=292)})
    private int overrideDebugKey(int value) {
        return DebugKeybinds.DEBUG.getKeyCode();
    }

    private int handleF3Escape(int value) {
        if (!InputConstants.isKeyDown((Window)ClientUtils.getClient().getWindow(), (int)DebugKeybinds.DEBUG.getKeyCode())) {
            return 256;
        }
        return DebugKeybinds.PAUSE_WITHOUT_MENU.getKeyCode();
    }

    @ModifyConstant(method={"keyPress"}, constant={@Constant(intValue=290)})
    private int handleF1(int value) {
        return DebugKeybinds.HIDE_GUI.getKeyCode();
    }

    @Inject(method={"keyPress"}, at={@At(value="FIELD", target="Lnet/minecraft/client/KeyboardHandler;handledDebugKey:Z", opcode=181, shift=At.Shift.AFTER)})
    public void activateWithoutDebugKey(long p_window, int action, KeyEvent event, CallbackInfo ci) {
        if (!((KeybindConfig)DebugKeybindMain.CONFIG.get()).requireDebugKey) {
            this.handledDebugKey = this.handleDebugKeys(DebugKeybinds.remapActionKey(event));
        }
    }

    @ModifyArg(method={"keyPress"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/KeyboardHandler;handleDebugKeys(Lnet/minecraft/client/input/KeyEvent;)Z"))
    private KeyEvent remapDebugKeys(KeyEvent event) {
        return ((KeybindConfig)DebugKeybindMain.CONFIG.get()).requireDebugKey ? DebugKeybinds.remapActionKey(event) : new KeyEvent(59, 0, 0);
    }

    @Inject(method={"handleDebugKeys"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideHelpMenuAndAddChunkKeys(KeyEvent event, CallbackInfoReturnable<Boolean> cir) {
        if (event == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (this.debugCrashKeyTime <= 0L || this.debugCrashKeyTime >= Util.getMillis() - 100L) {
            if (event.key() == 81) {
                this.debugFeedbackTranslated("debug.help.message");
                ChatComponent chatComponent = this.minecraft.gui.getChat();
                chatComponent.addMessage(GuiUtils.colorize((Component)GuiUtils.surround((String)"------------| ", (String)" |------------", (Component)GuiUtils.brackets((Component)GuiUtils.colorize((Component)Component.translatable((String)"controls.keybinds.debug.title"), (int)GuiUtils.BLUE))), (int)GuiUtils.GOLD));
                DebugKeybinds.createHelpComponents().forEach(arg_0 -> ((ChatComponent)chatComponent).addMessage(arg_0));
                chatComponent.addMessage(GuiUtils.colorize((Component)Component.literal((String)"----------------------------"), (int)GuiUtils.GOLD));
                cir.setReturnValue((Object)true);
            } else if (event.key() == 88) {
                Scheduling.nextTick(() -> {
                    ((KeybindConfig)DebugKeybindMain.CONFIG.get()).requireDebugKey = !((KeybindConfig)DebugKeybindMain.CONFIG.get()).requireDebugKey;
                    DebugKeybindMain.CONFIG.save();
                    this.debugFeedbackTranslated("debug.toggle_debug_key");
                });
                cir.setReturnValue((Object)true);
            } else {
                boolean bl = this.handleChunkDebugKeys(event);
                if (bl) {
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }
}

