/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.debugkeybind.gui;

import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.label.BLabel;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.debugkeybind.gui.KeybindButton;
import dev.boxadactle.debugkeybind.gui.ResetButton;
import dev.boxadactle.debugkeybind.keybind.DebugKeybind;
import dev.boxadactle.debugkeybind.keybind.DebugKeybinds;
import dev.boxadactle.debugkeybind.keybind.GlobalKeybind;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_304;
import net.minecraft.class_339;
import net.minecraft.class_4587;

public class KeybindEntry
extends BOptionScreen.ConfigList.ConfigEntry {
    public DebugKeybind keybind;
    public BLabel label;
    public KeybindButton keybindButton;
    public ResetButton resetButton;
    Runnable globalRefresh;

    public KeybindEntry(DebugKeybind keybind, Function<KeybindEntry, Boolean> onSelect, Runnable refresh) {
        this.label = new BLabel(keybind.getTranslation());
        this.keybindButton = new KeybindButton(keybind, () -> (Boolean)onSelect.apply(this));
        this.resetButton = new ResetButton(keybind, refresh);
        this.keybind = keybind;
        this.refresh();
        this.globalRefresh = refresh;
    }

    public List<? extends class_339> getWidgets() {
        return List.of(this.label, this.keybindButton, this.resetButton);
    }

    public boolean isInvalid() {
        return false;
    }

    public void updateKey(int code) {
        this.keybindButton.update(code);
        this.refresh();
        this.globalRefresh.run();
    }

    public void resetKey() {
        this.keybindButton.resetKey();
        this.globalRefresh.run();
    }

    public void refresh() {
        this.resetButton.refresh();
        if (this.keybind.isUnbound()) {
            this.keybindButton.updateConflicts(List.of());
            return;
        }
        List<String> collisions = this.keybind.checkConflicts(DebugKeybinds.toList());
        if (this.keybind instanceof GlobalKeybind) {
            class_304[] mappings = (class_304[])ClientUtils.getOptions().field_1839.clone();
            collisions.addAll(((GlobalKeybind)this.keybind).checkMinecraftConflicts(List.of(mappings)));
        }
        this.keybindButton.updateConflicts(collisions);
    }

    public void method_25343(class_4587 stack, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        int keybindWidth = 75;
        int resetWidth = 50;
        int padding = 2;
        this.label.field_22760 = x - 25;
        this.label.field_22761 = y;
        this.label.method_25358(entryWidth - keybindWidth - resetWidth - padding);
        this.label.method_25394(stack, mouseX, mouseY, tickDelta);
        this.keybindButton.field_22760 = x + entryWidth - keybindWidth - resetWidth - padding;
        this.keybindButton.field_22761 = y;
        this.keybindButton.method_25358(keybindWidth);
        this.keybindButton.method_25394(stack, mouseX, mouseY, tickDelta);
        this.resetButton.field_22760 = x + entryWidth - resetWidth;
        this.resetButton.field_22761 = y;
        this.resetButton.method_25358(resetWidth);
        this.resetButton.method_25394(stack, mouseX, mouseY, tickDelta);
    }
}

