/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.debugkeybind.keybind;

import com.google.common.collect.Lists;
import dev.boxadactle.boxlib.keybind.KeybindHelper;
import dev.boxadactle.debugkeybind.keybind.ActionKeybind;
import dev.boxadactle.debugkeybind.keybind.DebugKeybind;
import dev.boxadactle.debugkeybind.keybind.GlobalKeybind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_304;

public class DebugKeybinds {
    static List<GlobalKeybind> list = new ArrayList<GlobalKeybind>();
    static List<ActionKeybind> list2 = new ArrayList<ActionKeybind>();
    static HashMap<Integer, ActionKeybind> map = new HashMap();
    public static GlobalKeybind DEBUG = DebugKeybinds.createGlobalKeybind("key.debug.debugkeybind", 292);
    public static GlobalKeybind HIDE_GUI = DebugKeybinds.createGlobalKeybind("key.debug.hide_gui", 290);
    public static ActionKeybind RELOAD_CHUNKS = DebugKeybinds.createActionKeybind("key.debug_actions.reload_chunks", 65);
    public static ActionKeybind SHOW_HITBOXES = DebugKeybinds.createActionKeybind("key.debug_actions.show_hitboxes", 66);
    public static ActionKeybind COPY_LOCATION = DebugKeybinds.createActionKeybind("key.debug_actions.copy_location", 67);
    public static ActionKeybind CLEAR_CHAT = DebugKeybinds.createActionKeybind("key.debug_actions.clear_chat", 68);
    public static ActionKeybind CYCLE_RENDER_DISTANCE = DebugKeybinds.createActionKeybind("key.debug_actions.cycle_render_distance", 70);
    public static ActionKeybind CHUNK_BORDERS = DebugKeybinds.createActionKeybind("key.debug_actions.chunk_borders", 71);
    public static ActionKeybind ADVANCED_TOOLTIPS = DebugKeybinds.createActionKeybind("key.debug_actions.advanced_tooltips", 72);
    public static ActionKeybind INSPECT = DebugKeybinds.createActionKeybind("key.debug_actions.inspect", 73);
    public static ActionKeybind CREATIVE_SPECTATOR = DebugKeybinds.createActionKeybind("key.debug_actions.creative_spectator", 78);
    public static ActionKeybind PAUSE_FOCUS = DebugKeybinds.createActionKeybind("key.debug_actions.pause_focus", 80);
    public static ActionKeybind HELP = DebugKeybinds.createActionKeybind("key.debug_actions.help", 81);
    public static ActionKeybind RELOAD_RESOURCEPACKS = DebugKeybinds.createActionKeybind("key.debug_actions.reload_resourcepacks", 84);
    public static ActionKeybind OPEN_GAMEMODE_SWITCHER = DebugKeybinds.createActionKeybind("key.debug_actions.open_gamemode_switcher", 293);
    public static ActionKeybind PAUSE_WITHOUT_MENU = DebugKeybinds.createActionKeybind("key.debug_actions.pause_without_menu", 256);

    public static void refreshActionBindings() {
        map.clear();
        for (ActionKeybind k : list2) {
            map.put(k.getKeyCode(), k);
        }
    }

    public static int remapActionKey(int code) {
        int keyCode;
        ActionKeybind k = map.get(code);
        int n = keyCode = k != null ? k.getDefaultKeyCode() : -1;
        if (keyCode == -1) {
            for (ActionKeybind key : list2) {
                if (key.getDefaultKeyCode() != code) continue;
                return -1;
            }
        }
        return keyCode != -1 ? keyCode : code;
    }

    public static List<DebugKeybind> toList() {
        ArrayList<DebugKeybind> keybinds = new ArrayList<DebugKeybind>();
        keybinds.addAll(DebugKeybinds.getGlobalKeybinds());
        keybinds.addAll(DebugKeybinds.getActionKeybinds());
        return keybinds;
    }

    public static List<DebugKeybind> getGlobalKeybinds() {
        return Lists.newArrayList((Object[])new DebugKeybind[]{DEBUG, HIDE_GUI});
    }

    public static List<DebugKeybind> getActionKeybinds() {
        return Lists.newArrayList((Object[])new DebugKeybind[]{RELOAD_CHUNKS, SHOW_HITBOXES, COPY_LOCATION, CYCLE_RENDER_DISTANCE, CLEAR_CHAT, CHUNK_BORDERS, ADVANCED_TOOLTIPS, INSPECT, CREATIVE_SPECTATOR, PAUSE_FOCUS, HELP, RELOAD_RESOURCEPACKS, OPEN_GAMEMODE_SWITCHER, PAUSE_WITHOUT_MENU});
    }

    public static List<String> getCollisions(class_304 k) {
        ArrayList<String> collisions = new ArrayList<String>();
        for (GlobalKeybind key : list) {
            if (key.getKeyCode() != KeybindHelper.getBoundKey((class_304)k).method_1444()) continue;
            collisions.add(class_1074.method_4662((String)key.getName(), (Object[])new Object[0]));
        }
        return collisions;
    }

    public static DebugKeybind[] toArray() {
        return DebugKeybinds.toList().toArray(new DebugKeybind[0]);
    }

    private static GlobalKeybind createGlobalKeybind(String key, int i) {
        GlobalKeybind keybind = new GlobalKeybind(key, i, "key.categories.debug");
        list.add(keybind);
        return keybind;
    }

    private static ActionKeybind createActionKeybind(String key, int i) {
        ActionKeybind keybind = new ActionKeybind(key, i, "key.categories.debug_actions");
        list2.add(keybind);
        return keybind;
    }
}

