/*
 * Decompiled with CFR 0.152.
 */
package nl.ThebigTijn.randomspawn;

import java.util.Random;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import nl.ThebigTijn.randomspawn.config.ModConfigs;
import nl.ThebigTijn.randomspawn.util.JoinData;

public class Randomspawn
implements ModInitializer {
    int minX;
    int maxX;
    int minZ;
    int maxZ;

    public void onInitialize() {
        this.loadConfig();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (JoinData.isFirstJoin(handler.method_32311()) & ModConfigs.SpawnOnFirstJoin) {
                this.teleportPlayerToRandomLocation(handler.method_32311());
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (!this.playerHasRespawnPoint(newPlayer) & ModConfigs.SpawnOnRespawn) {
                new Thread(() -> {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    this.teleportPlayerToRandomLocation(newPlayer);
                }).start();
            }
        });
    }

    private void loadConfig() {
        ModConfigs.registerConfigs();
        this.minX = ModConfigs.MinX;
        this.maxX = ModConfigs.MaxX;
        this.minZ = ModConfigs.MinZ;
        this.maxZ = ModConfigs.MaxZ;
    }

    private boolean playerHasRespawnPoint(class_3222 player) {
        return player.method_26280() != null;
    }

    private void teleportPlayerToRandomLocation(class_3222 player) {
        Random[] random = new Random[]{new Random()};
        class_3218 world = player.method_5682().method_30002();
        int[] x = new int[]{this.minX + random[0].nextInt(this.maxX - this.minX + 1)};
        int[] z = new int[]{this.minZ + random[0].nextInt(this.maxZ - this.minZ + 1)};
        class_2338[] pos = new class_2338[]{this.findSolidGround(world, x[0], z[0])};
        new Thread(() -> {
            while (!world.method_8320(pos[0]).method_26215()) {
                random[0] = new Random();
                x[0] = this.minX + random[0].nextInt(this.maxX - this.minX + 1);
                z[0] = this.minZ + random[0].nextInt(this.maxZ - this.minZ + 1);
                pos[0] = this.findSolidGround(world, x[0], z[0]);
                if (pos[0] == null || !world.method_8320(pos[0]).method_26215()) continue;
                player.method_14251(world, (double)pos[0].method_10263() + 0.5, (double)pos[0].method_10264(), (double)pos[0].method_10260() + 0.5, player.method_36454(), player.method_36455());
            }
        }).start();
    }

    private class_2338 findSolidGround(class_3218 world, int x, int z) {
        for (int y = world.method_31600() - 1; y > 0; --y) {
            class_2338 pos = new class_2338(x, y, z);
            if (!world.method_8320(pos).method_51367()) continue;
            return pos.method_10086(1);
        }
        return null;
    }
}

