/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits;

import fanlim.dev.oaexploits.antiexploits.AntiIllegalItems;
import fanlim.dev.oaexploits.antiexploits.IllegalEnchantmentReverter;
import fanlim.dev.oaexploits.antiexploits.OaExploitsGUI;
import fanlim.dev.oaexploits.chunks.ChunkLimiter;
import fanlim.dev.oaexploits.chunks.withersound;
import fanlim.dev.oaexploits.commands.CommandBlocker;
import fanlim.dev.oaexploits.commands.ReloadCommand;
import fanlim.dev.oaexploits.players.PlayerDeopOnLeave;
import fanlim.dev.oaexploits.stats.PlayTimeStats;
import fanlim.dev.oaexploits.stats.WorldStats;
import fanlim.dev.oaexploits.updates.UpdateChecker;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Oaexploits
extends JavaPlugin
implements Listener {
    private String commandBlockedMessage;
    private String pluginsCommandBlockedMessage;
    private boolean whitelistEnabled;
    private Set<String> commandWhitelist = new HashSet<String>();
    private boolean blacklistEnabled;
    private Set<String> commandBlacklist = new HashSet<String>();
    private boolean debugEnabled;
    private FileConfiguration worldStatsConfig;
    private OaExploitsGUI oaExploitsGUI;
    private CommandBlocker commandBlocker;
    private IllegalEnchantmentReverter illegalEnchantmentReverter;
    private withersound witherSound;
    private UpdateChecker updateChecker;
    private PlayerDeopOnLeave playerDeopOnLeave;
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_LIGHT_BLUE = "\u001b[94m";

    public void onEnable() {
        this.displayStartupMessage();
        this.saveDefaultConfig();
        this.loadAndMergeConfig();
        this.loadAndMergeWorldStatsConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("Oaexploits plugin enabled!");
        this.witherSound = new withersound(this);
        this.oaExploitsGUI = new OaExploitsGUI(this, this.witherSound);
        this.getServer().getPluginManager().registerEvents((Listener)this.oaExploitsGUI, (Plugin)this);
        ChunkLimiter chunkLimiter = new ChunkLimiter(this);
        this.getServer().getPluginManager().registerEvents((Listener)chunkLimiter, (Plugin)this);
        AntiIllegalItems antiIllegalItems = new AntiIllegalItems(this);
        this.getServer().getPluginManager().registerEvents((Listener)antiIllegalItems, (Plugin)this);
        this.illegalEnchantmentReverter = new IllegalEnchantmentReverter(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.illegalEnchantmentReverter, (Plugin)this);
        this.playerDeopOnLeave = new PlayerDeopOnLeave(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerDeopOnLeave, (Plugin)this);
        if (this.getCommand("worldstats") != null) {
            this.getCommand("worldstats").setExecutor((CommandExecutor)new WorldStats(this));
        }
        this.commandBlocker = new CommandBlocker(this);
        if (this.getCommand("oaexploits") != null) {
            this.getCommand("oaexploits").setExecutor((CommandExecutor)new ReloadCommand(this, antiIllegalItems, this.illegalEnchantmentReverter, chunkLimiter, this.playerDeopOnLeave, this.commandBlocker, this.witherSound));
        }
        PlayTimeStats playTimeStats = new PlayTimeStats(this);
        if (this.getCommand("playtime") != null) {
            this.getCommand("playtime").setExecutor((CommandExecutor)playTimeStats);
            this.getCommand("playtime").setTabCompleter((TabCompleter)playTimeStats);
        }
        this.getServer().getPluginManager().registerEvents((Listener)this.commandBlocker, (Plugin)this);
        if (this.getCommand("oaexploitsgui") != null) {
            this.getCommand("oaexploitsgui").setExecutor((sender, command, label, args) -> {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (player.isOp()) {
                        this.oaExploitsGUI.openSettingsGUI(player);
                        return true;
                    }
                    player.sendMessage("You do not have permission to use this command.");
                    return true;
                }
                sender.sendMessage("This command can only be executed by a player.");
                return true;
            });
        }
        this.updateChecker = new UpdateChecker(this);
        this.updateChecker.checkForUpdates();
    }

    public void onDisable() {
        if (this.playerDeopOnLeave != null) {
            this.playerDeopOnLeave.handleAllOnlinePlayers();
        }
        this.getLogger().info("Oaexploits plugin disabled!");
    }

    public PlayerDeopOnLeave getPlayerDeopOnLeave() {
        return this.playerDeopOnLeave;
    }

    private void loadAndMergeConfig() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.saveDefaultConfig();
        } else {
            try (InputStreamReader resourceReader = new InputStreamReader(this.getResource("config.yml"));){
                if (resourceReader != null) {
                    String configVersion;
                    YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)resourceReader);
                    YamlConfiguration currentConfig = YamlConfiguration.loadConfiguration((File)configFile);
                    String pluginVersion = this.getDescription().getVersion();
                    if (!pluginVersion.equals(configVersion = currentConfig.getString("config-version", ""))) {
                        for (String key : defaultConfig.getKeys(true)) {
                            if (currentConfig.contains(key)) continue;
                            currentConfig.set(key, defaultConfig.get(key));
                        }
                        currentConfig.set("config-version", (Object)pluginVersion);
                        currentConfig.save(configFile);
                        this.getLogger().info("Configuration updated to version " + pluginVersion);
                    }
                } else {
                    this.getLogger().log(Level.SEVERE, "Could not find resource 'config.yml'");
                }
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Could not merge configuration file", e);
            }
        }
        this.loadConfigValues();
    }

    public void loadAndMergeWorldStatsConfig() {
        File worldStatsFile = new File(this.getDataFolder(), "worldstats.yml");
        if (!worldStatsFile.exists()) {
            this.saveResource("worldstats.yml", false);
        } else {
            try (InputStreamReader resourceReader = new InputStreamReader(this.getResource("worldstats.yml"));){
                if (resourceReader != null) {
                    String configVersion;
                    YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)resourceReader);
                    YamlConfiguration currentConfig = YamlConfiguration.loadConfiguration((File)worldStatsFile);
                    String pluginVersion = this.getDescription().getVersion();
                    if (!pluginVersion.equals(configVersion = currentConfig.getString("config-version", ""))) {
                        for (String key : defaultConfig.getKeys(true)) {
                            if (currentConfig.contains(key)) continue;
                            currentConfig.set(key, defaultConfig.get(key));
                        }
                        currentConfig.set("config-version", (Object)pluginVersion);
                        currentConfig.save(worldStatsFile);
                        this.getLogger().info("World stats configuration updated to version " + pluginVersion);
                    }
                } else {
                    this.getLogger().log(Level.SEVERE, "Could not find resource 'worldstats.yml'");
                }
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "Could not merge world stats configuration file", e);
            }
        }
        this.worldStatsConfig = YamlConfiguration.loadConfiguration((File)worldStatsFile);
    }

    public void loadConfigValues() {
        FileConfiguration config = this.getConfig();
        this.commandBlockedMessage = ((TextComponent)Component.text(config.getString("messages.command-blocked.text", "&cYou cannot use this command!")).color(NamedTextColor.RED)).toString();
        this.pluginsCommandBlockedMessage = ((TextComponent)Component.text(config.getString("messages.plugins-command-blocked.text", "&cYou cannot view the plugins!")).color(NamedTextColor.RED)).toString();
        this.whitelistEnabled = config.getBoolean("command-whitelist.enabled", false);
        this.commandWhitelist = this.normalizeCommands(config.getStringList("command-whitelist.commands"));
        this.blacklistEnabled = config.getBoolean("command-blacklist.enabled", true);
        this.commandBlacklist = this.normalizeCommands(config.getStringList("command-blacklist.commands"));
        this.debugEnabled = config.getBoolean("debug-mode", false);
    }

    public FileConfiguration getWorldStatsConfig() {
        return this.worldStatsConfig;
    }

    private Set<String> normalizeCommands(List<String> commands) {
        return commands.stream().map(command -> command.trim().replaceAll("^/+", "").toLowerCase()).collect(Collectors.toSet());
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage().toLowerCase();
        Player player = event.getPlayer();
        if ((message.startsWith("/give") || message.startsWith("/i") || message.startsWith("/item")) && !player.isOp()) {
            event.setCancelled(true);
            if (this.debugEnabled) {
                player.sendMessage(this.commandBlockedMessage);
            }
        }
    }

    private void displayStartupMessage() {
        String[] message;
        for (String line : message = new String[]{" \u2588\u2588\u2588\u2588\u2588\u2588\u2557  \u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2557  \u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2557      \u2588\u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557", "\u2588\u2588\u2554\u2550\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d\u255a\u2588\u2588\u2557\u2588\u2588\u2554\u255d\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2551     \u2588\u2588\u2554\u2550\u2550\u2550\u2588\u2588\u2557\u2588\u2588\u2551\u255a\u2550\u2550\u2588\u2588\u2554\u2550\u2550\u255d\u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d", "\u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2557   \u255a\u2588\u2588\u2588\u2554\u255d \u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u2588\u2588\u2551     \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2551   \u2588\u2588\u2551   \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557", "\u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u255d   \u2588\u2588\u2554\u2588\u2588\u2557 \u2588\u2588\u2554\u2550\u2550\u2550\u255d \u2588\u2588\u2551     \u2588\u2588\u2551   \u2588\u2588\u2551\u2588\u2588\u2551   \u2588\u2588\u2551   \u255a\u2550\u2550\u2550\u2550\u2588\u2588\u2551", "\u255a\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u2588\u2588\u2551  \u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u2588\u2588\u2554\u255d \u2588\u2588\u2557\u2588\u2588\u2551     \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2557\u255a\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d\u2588\u2588\u2551   \u2588\u2588\u2551   \u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2551", " \u255a\u2550\u2550\u2550\u2550\u2550\u255d \u255a\u2550\u255d  \u255a\u2550\u255d\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d\u255a\u2550\u255d  \u255a\u2550\u255d\u255a\u2550\u255d     \u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d \u255a\u2550\u2550\u2550\u2550\u2550\u255d \u255a\u2550\u255d   \u255a\u2550\u255d   \u255a\u2550\u2550\u2550\u2550\u2550\u2550\u255d", "                                                                              "}) {
            this.getLogger().info(ANSI_LIGHT_BLUE + line + ANSI_RESET);
        }
    }

    public String getPluginsCommandBlockedMessage() {
        return this.pluginsCommandBlockedMessage;
    }

    public boolean isWhitelistEnabled() {
        return this.whitelistEnabled;
    }

    public Set<String> getCommandWhitelist() {
        return this.commandWhitelist;
    }

    public boolean isBlacklistEnabled() {
        return this.blacklistEnabled;
    }

    public Set<String> getCommandBlacklist() {
        return this.commandBlacklist;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public CommandBlocker getCommandBlocker() {
        return this.commandBlocker;
    }
}

