/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.antiexploits;

import fanlim.dev.oaexploits.Oaexploits;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class IllegalEnchantmentReverter
implements Listener {
    private final Oaexploits plugin;
    private final Logger logger;
    private final Map<Enchantment, Integer> maxEnchantmentLevels = new HashMap<Enchantment, Integer>();
    private boolean revertEnchantmentItems;
    private boolean notifyEnchantmentPlayer;
    private boolean logEnchantmentItems;
    private final Map<Player, Integer> illegalEnchantmentCount = new HashMap<Player, Integer>();

    public IllegalEnchantmentReverter(Oaexploits plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.loadConfigValues();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void loadConfigValues() {
        FileConfiguration config = this.plugin.getConfig();
        this.maxEnchantmentLevels.clear();
        if (config.getConfigurationSection("max_enchantment_levels") != null) {
            for (String key : config.getConfigurationSection("max_enchantment_levels").getKeys(false)) {
                Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)key.toLowerCase()));
                if (enchantment != null) {
                    this.maxEnchantmentLevels.put(enchantment, config.getInt("max_enchantment_levels." + key));
                    continue;
                }
                this.logger.warning("Invalid enchantment name in config: " + key);
            }
        }
        this.revertEnchantmentItems = config.getBoolean("enchantment_settings.revert_items", true);
        this.notifyEnchantmentPlayer = config.getBoolean("enchantment_settings.notify_player", true);
        this.logEnchantmentItems = config.getBoolean("enchantment_settings.log_illegal_items", true);
    }

    private String convertToAnsi(String message) {
        return message.replace("\u00a70", "\u001b[30m").replace("\u00a71", "\u001b[34m").replace("\u00a72", "\u001b[32m").replace("\u00a73", "\u001b[36m").replace("\u00a74", "\u001b[31m").replace("\u00a75", "\u001b[35m").replace("\u00a76", "\u001b[33m").replace("\u00a77", "\u001b[37m").replace("\u00a78", "\u001b[90m").replace("\u00a79", "\u001b[94m").replace("\u00a7a", "\u001b[92m").replace("\u00a7b", "\u001b[96m").replace("\u00a7c", "\u001b[91m").replace("\u00a7d", "\u001b[95m").replace("\u00a7e", "\u001b[93m").replace("\u00a7f", "\u001b[97m").replace("\u00a7r", "\u001b[0m");
    }

    private void handleItemCheck(ItemStack item, Player player) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (this.hasIllegalEnchantment(item)) {
            if (this.logEnchantmentItems && player != null) {
                this.incrementIllegalEnchantmentCount(player);
            }
            if (this.revertEnchantmentItems) {
                this.revertIllegalEnchantments(item);
            }
            if (this.notifyEnchantmentPlayer && player != null) {
                this.aggregateIllegalEnchantmentMessage(player, item);
            }
        }
    }

    private boolean hasIllegalEnchantment(ItemStack item) {
        return item.getEnchantments().entrySet().stream().anyMatch(entry -> (Integer)entry.getValue() > this.maxEnchantmentLevels.getOrDefault(entry.getKey(), ((Enchantment)entry.getKey()).getMaxLevel()));
    }

    private void revertIllegalEnchantments(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            item.getEnchantments().forEach((enchantment, level) -> {
                int maxLevel = this.maxEnchantmentLevels.getOrDefault(enchantment, enchantment.getMaxLevel());
                meta.removeEnchant(enchantment);
                if (level > 0) {
                    meta.addEnchant(enchantment, Math.min(level, maxLevel), true);
                }
            });
            item.setItemMeta(meta);
        }
    }

    private void aggregateIllegalEnchantmentMessage(Player player, ItemStack item) {
        String itemName = item.getType().toString();
        String enchantments = this.getEnchantmentsString(item);
        String message = String.format("\u00a7eIllegal enchantment detected on item: \u00a7c%s \u00a7ewith enchantments: \u00a7c%s", itemName, enchantments);
        TextComponent componentMessage = Component.text(message);
        player.sendMessage((Component)componentMessage);
    }

    private String getEnchantmentsString(ItemStack item) {
        StringBuilder enchantments = new StringBuilder();
        item.getEnchantments().forEach((enchantment, level) -> enchantments.append(enchantment.getKey().getKey()).append("=").append(level).append(", "));
        if (!enchantments.isEmpty()) {
            enchantments.setLength(enchantments.length() - 2);
        }
        return enchantments.toString();
    }

    private void incrementIllegalEnchantmentCount(Player player) {
        this.illegalEnchantmentCount.put(player, this.illegalEnchantmentCount.getOrDefault(player, 0) + 1);
    }

    private void checkInventory(Inventory inventory, Player player) {
        for (ItemStack item : inventory.getContents()) {
            this.handleItemCheck(item, player);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        this.handleItemCheck(event.getCurrentItem(), (Player)event.getWhoClicked());
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        this.handleItemCheck(event.getItem(), null);
    }

    @EventHandler
    public void onInventoryPickupItem(InventoryPickupItemEvent event) {
        this.handleItemCheck(event.getItem().getItemStack(), null);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.checkInventory((Inventory)event.getPlayer().getInventory(), event.getPlayer());
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        Player player = (Player)event.getPlayer();
        this.illegalEnchantmentCount.put(player, 0);
        this.checkInventory(event.getInventory(), player);
        if (this.illegalEnchantmentCount.get(player) > 0) {
            String message = String.format("%d illegal enchantments detected in the container opened by player: %s", this.illegalEnchantmentCount.get(player), player.getName());
            this.logger.warning(this.convertToAnsi("\u00a7e" + message));
            if (this.notifyEnchantmentPlayer) {
                player.sendMessage(Component.text(message).color(NamedTextColor.YELLOW));
            }
        }
    }

    @EventHandler
    public void onPlayerAttemptPickupItem(PlayerAttemptPickupItemEvent event) {
        this.handleItemCheck(event.getItem().getItemStack(), event.getPlayer());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.handleItemCheck(event.getItem(), event.getPlayer());
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        this.handleItemCheck(event.getItemDrop().getItemStack(), event.getPlayer());
    }

    @EventHandler
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.handleItemCheck(event.getItem().getItemStack(), player);
        }
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        this.handleItemCheck(event.getPlayer().getInventory().getItem(event.getNewSlot()), event.getPlayer());
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handleItemCheck(player.getInventory().getItemInMainHand(), player);
            this.handleItemCheck(player.getInventory().getItemInOffHand(), player);
        }
    }

    public void reloadConfigValues() {
        this.loadConfigValues();
    }
}

