/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.antiexploits;

import fanlim.dev.oaexploits.Oaexploits;
import fanlim.dev.oaexploits.chunks.withersound;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.IntStream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class OaExploitsGUI
implements Listener {
    private static final Component GUI_TITLE = Component.text("OaExploits Settings").color(NamedTextColor.GOLD);
    private static final Component TOGGLE_ILLEGAL_ITEMS = Component.text("Toggle Illegal Items Removal").color(NamedTextColor.RED);
    private static final Component TOGGLE_ADMIN_ALERTS = Component.text("Toggle Admin Alerts").color(NamedTextColor.BLUE);
    private static final Component TOGGLE_SHULKER_CLEAN = Component.text("Toggle Shulker Box Cleaning").color(NamedTextColor.GREEN);
    private static final Component TOGGLE_ENCHANTMENT_REVERT = Component.text("Toggle Enchantment Reversion").color(NamedTextColor.AQUA);
    private static final Component TOGGLE_NOTIFY_PLAYER = Component.text("Toggle Enchantment Player Notification").color(NamedTextColor.LIGHT_PURPLE);
    private static final Component TOGGLE_LOG_ENCHANTMENT_ITEMS = Component.text("Toggle Logging of Illegal Enchantments").color(NamedTextColor.DARK_PURPLE);
    private static final Component RELOAD_CONFIGURATION = Component.text("Reload Configuration").color(NamedTextColor.YELLOW);
    private static final Component CLEAR_WITHERS = Component.text("Clear Withers in Chunk").color(NamedTextColor.DARK_RED);
    private static final Component BORDER_ITEM = Component.text(" ").color(NamedTextColor.GRAY);
    private final Oaexploits plugin;
    private final withersound witherSound;
    private final Map<UUID, Long> lastInteractionTimes = new HashMap<UUID, Long>();
    private final Set<UUID> playersWithGuiOpen = new HashSet<UUID>();
    private final Map<Component, Runnable> componentHandlers = new HashMap<Component, Runnable>();

    public OaExploitsGUI(Oaexploits plugin, withersound witherSound) {
        this.plugin = plugin;
        this.witherSound = witherSound;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.initializeComponentHandlers();
    }

    private void initializeComponentHandlers() {
        this.componentHandlers.put(TOGGLE_ILLEGAL_ITEMS, () -> this.handleConfigOptionClick("removal-options.remove-illegal-items", "Illegal Items Removal"));
        this.componentHandlers.put(TOGGLE_ADMIN_ALERTS, () -> this.handleConfigOptionClick("admin-alerts.enabled", "Admin Alerts"));
        this.componentHandlers.put(TOGGLE_SHULKER_CLEAN, () -> this.handleConfigOptionClick("removal-options.clean-shulkers-on-place", "Shulker Box Cleaning"));
        this.componentHandlers.put(TOGGLE_ENCHANTMENT_REVERT, () -> this.handleConfigOptionClick("enchantment_settings.revert_items", "Enchantment Reversion"));
        this.componentHandlers.put(TOGGLE_NOTIFY_PLAYER, () -> this.handleConfigOptionClick("enchantment_settings.notify_player", "Enchantment Player Notification"));
        this.componentHandlers.put(TOGGLE_LOG_ENCHANTMENT_ITEMS, () -> this.handleConfigOptionClick("enchantment_settings.log_illegal_items", "Logging of Illegal Enchantments"));
        this.componentHandlers.put(RELOAD_CONFIGURATION, this::reloadPluginConfig);
        this.componentHandlers.put(CLEAR_WITHERS, this::clearWithers);
    }

    public void openSettingsGUI(Player player) {
        if (!player.isOp()) {
            player.sendMessage(Component.text("You do not have permission to use this GUI.").color(NamedTextColor.RED));
            return;
        }
        Inventory gui = Bukkit.createInventory((InventoryHolder)new OaExploitsInventoryHolder(player.getUniqueId()), (int)36, (Component)GUI_TITLE);
        this.addBorderItems(gui);
        this.setSettingItems(gui);
        player.openInventory(gui);
        this.playSound(player, Sound.BLOCK_NOTE_BLOCK_PLING);
        this.playParticleEffect(player, Particle.HAPPY_VILLAGER);
        this.playersWithGuiOpen.add(player.getUniqueId());
    }

    private void addBorderItems(Inventory gui) {
        IntStream.range(0, gui.getSize()).filter(i -> !this.isSettingSlot(i)).forEach(i -> gui.setItem(i, this.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, BORDER_ITEM, new Component[0])));
    }

    private boolean isSettingSlot(int slot) {
        return switch (slot) {
            case 10, 12, 14, 16, 18, 20, 22, 24 -> true;
            default -> false;
        };
    }

    private void setSettingItems(Inventory gui) {
        gui.setItem(10, this.createSettingItem(Material.REDSTONE_TORCH, TOGGLE_ILLEGAL_ITEMS, "removal-options.remove-illegal-items", "Enable or disable automatic removal of illegal items."));
        gui.setItem(12, this.createSettingItem(Material.JUKEBOX, TOGGLE_ADMIN_ALERTS, "admin-alerts.enabled", "Enable or disable admin alerts for illegal activities."));
        gui.setItem(14, this.createSettingItem(Material.SHULKER_BOX, TOGGLE_SHULKER_CLEAN, "removal-options.clean-shulkers-on-place", "Enable or disable shulker box cleaning on placement."));
        gui.setItem(16, this.createSettingItem(Material.ENCHANTED_BOOK, TOGGLE_ENCHANTMENT_REVERT, "enchantment_settings.revert_items", "Enable or disable enchantment reversion."));
        gui.setItem(18, this.createSettingItem(Material.PAPER, TOGGLE_NOTIFY_PLAYER, "enchantment_settings.notify_player", "Enable or disable player notification for illegal enchantments."));
        gui.setItem(20, this.createSettingItem(Material.BOOK, TOGGLE_LOG_ENCHANTMENT_ITEMS, "enchantment_settings.log_illegal_items", "Enable or disable logging of illegal enchantments."));
        gui.setItem(22, this.createGuiItem(Material.WRITABLE_BOOK, RELOAD_CONFIGURATION, Component.text("Reload the plugin configuration.").color(NamedTextColor.WHITE)));
        gui.setItem(24, this.createGuiItem(Material.WITHER_SKELETON_SKULL, CLEAR_WITHERS, Component.text("Clear all Withers in the chunk.").color(NamedTextColor.WHITE)));
    }

    private ItemStack createGuiItem(Material material, Component displayName, Component ... lore) {
        ItemStack item = new ItemStack(material);
        Optional.ofNullable(item.getItemMeta()).ifPresent(meta -> {
            meta.displayName(displayName);
            meta.lore(Arrays.asList(lore));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            item.setItemMeta(meta);
        });
        return item;
    }

    private ItemStack createSettingItem(Material material, Component displayName, String configPath, String description) {
        boolean isEnabled = this.plugin.getConfig().getBoolean(configPath);
        return this.createGuiItem(material, displayName, Component.text(description).color(NamedTextColor.WHITE), Component.text("Current: " + (isEnabled ? "Enabled" : "Disabled")).color(isEnabled ? NamedTextColor.GREEN : NamedTextColor.RED), Component.text("Click to toggle this setting.").color(NamedTextColor.GRAY));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        OaExploitsInventoryHolder holder;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        UUID playerId = player.getUniqueId();
        if (!this.playersWithGuiOpen.contains(playerId)) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastInteractionTimes.getOrDefault(playerId, 0L) + 1000L > currentTime) {
            event.setCancelled(true);
            return;
        }
        this.lastInteractionTimes.put(playerId, currentTime);
        Inventory inventory = event.getClickedInventory();
        if (inventory == null || event.getCurrentItem() == null) {
            return;
        }
        ItemMeta itemMeta = event.getCurrentItem().getItemMeta();
        if (itemMeta == null) {
            return;
        }
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (inventoryHolder instanceof OaExploitsInventoryHolder && (holder = (OaExploitsInventoryHolder)inventoryHolder).ownerUUID().equals(player.getUniqueId())) {
            event.setCancelled(true);
            Component displayName = itemMeta.displayName();
            if (!player.isOp()) {
                player.sendMessage(Component.text("You do not have permission to change these settings.").color(NamedTextColor.RED));
                return;
            }
            Optional.ofNullable(this.componentHandlers.get(displayName)).ifPresentOrElse(Runnable::run, () -> player.sendMessage(Component.text("Unrecognized option. Please try again.").color(NamedTextColor.RED)));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.refreshSettingsGUI(player), 1L);
        }
    }

    private void handleConfigOptionClick(String configPath, String optionName) {
        boolean newValue = !this.plugin.getConfig().getBoolean(configPath);
        this.plugin.getConfig().set(configPath, (Object)newValue);
        this.saveConfigAsync();
        this.notifyPlayerConfigChange(optionName, newValue);
    }

    private void notifyPlayerConfigChange(String optionName, boolean newValue) {
        Bukkit.getOnlinePlayers().stream().filter(p -> p.getOpenInventory().getTopInventory().getHolder() instanceof OaExploitsInventoryHolder).forEach(player -> {
            player.sendMessage(Component.text(optionName + ": " + (newValue ? "Enabled" : "Disabled")).color(newValue ? NamedTextColor.GREEN : NamedTextColor.RED));
            this.plugin.getLogger().info(optionName + " set to " + newValue + " by " + player.getName());
            this.playSound((Player)player, Sound.ENTITY_PLAYER_LEVELUP);
            this.playParticleEffect((Player)player, Particle.HAPPY_VILLAGER);
        });
    }

    private void saveConfigAsync() {
        CompletableFuture.runAsync(() -> ((Oaexploits)this.plugin).saveConfig()).exceptionally(ex -> {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save config", (Throwable)ex);
            return null;
        });
    }

    private void reloadPluginConfig() {
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        Bukkit.dispatchCommand((CommandSender)sender, (String)"oaexploits reload");
        Bukkit.getOnlinePlayers().stream().filter(p -> p.getOpenInventory().getTopInventory().getHolder() instanceof OaExploitsInventoryHolder).forEach(player -> {
            player.sendMessage(Component.text("Configuration reloaded.").color(NamedTextColor.GREEN));
            this.playSound((Player)player, Sound.BLOCK_ANVIL_USE);
            this.playParticleEffect((Player)player, Particle.EXPLOSION_EMITTER);
        });
    }

    private void clearWithers() {
        Bukkit.getOnlinePlayers().stream().filter(p -> p.getOpenInventory().getTopInventory().getHolder() instanceof OaExploitsInventoryHolder).forEach(this.witherSound::clearWithersInChunk);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().getHolder() instanceof OaExploitsInventoryHolder) {
            UUID playerId = event.getPlayer().getUniqueId();
            this.playersWithGuiOpen.remove(playerId);
            this.lastInteractionTimes.remove(playerId);
        }
    }

    private void refreshSettingsGUI(Player player) {
        Inventory gui = player.getOpenInventory().getTopInventory();
        this.setSettingItems(gui);
    }

    private void playSound(Player player, Sound sound) {
        player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
    }

    private void playParticleEffect(Player player, Particle particle) {
        player.spawnParticle(particle, player.getLocation(), 10);
    }

    public record OaExploitsInventoryHolder(UUID ownerUUID) implements InventoryHolder
    {
        @NotNull
        public Inventory getInventory() {
            return Bukkit.createInventory(null, (int)0);
        }
    }
}

