/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.chunks;

import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wither;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class withersound
implements Listener {
    private final JavaPlugin plugin;
    private int radius;
    private Sound sound;

    public withersound(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfigValues();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void loadConfigValues() {
        Sound tempSound;
        FileConfiguration config = this.plugin.getConfig();
        this.radius = config.getInt("wither-sound.radius", 20);
        try {
            tempSound = Sound.valueOf((String)config.getString("wither-sound.sound", "ENTITY_WITHER_SPAWN").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().log(Level.WARNING, "Invalid sound type in configuration. Defaulting to ENTITY_WITHER_SPAWN.", e);
            tempSound = Sound.ENTITY_WITHER_SPAWN;
        }
        this.sound = tempSound;
    }

    @EventHandler
    public void onWitherSpawn(CreatureSpawnEvent event) {
        if (event.getEntityType() == EntityType.WITHER) {
            Wither wither = (Wither)event.getEntity();
            Location location = wither.getLocation();
            this.playSoundWithinRadius(location, this.radius, this.sound);
        }
    }

    private void playSoundWithinRadius(Location location, int radius, Sound sound) {
        location.getWorld().getNearbyEntities(location, (double)radius, (double)radius, (double)radius).stream().filter(entity -> entity instanceof Player).forEach(entity -> ((Player)entity).playSound(location, sound, 1.0f, 1.0f));
    }

    public void clearWithersInChunk(Player player) {
        Chunk chunk = player.getLocation().getChunk();
        int count = 0;
        for (Entity entity : chunk.getEntities()) {
            if (entity.getType() != EntityType.WITHER) continue;
            entity.remove();
            ++count;
        }
        player.sendMessage(count + " Wither(s) removed from the chunk.");
    }
}

