/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.banmanager;

import fanlim.dev.oaexploits.Oaexploits;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class SelectPlayerToUnbanGUI
implements Listener {
    private static final Component SELECT_PLAYER_TITLE = Component.text("Select Player to Unban").color(NamedTextColor.DARK_GREEN);
    private final Oaexploits plugin;

    public SelectPlayerToUnbanGUI(Oaexploits plugin, @NotNull UUID uniqueId) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openSelectPlayerGUI(Player admin) {
        Inventory selectPlayerGui = Bukkit.createInventory((InventoryHolder)new SelectPlayerInventoryHolder(), (int)54, (Component)SELECT_PLAYER_TITLE);
        this.populateInventoryWithBannedPlayers(selectPlayerGui, 0);
        admin.openInventory(selectPlayerGui);
        this.playSound(admin, Sound.BLOCK_NOTE_BLOCK_PLING);
    }

    private void populateInventoryWithBannedPlayers(Inventory inventory, int page) {
        ArrayList bannedPlayers = new ArrayList(Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntries());
        int startIndex = page * 45;
        int endIndex = Math.min(startIndex + 45, bannedPlayers.size());
        for (int i = startIndex; i < endIndex; ++i) {
            inventory.setItem(i - startIndex, this.createPlayerHeadItem((BanEntry)bannedPlayers.get(i)));
        }
        this.fillEmptySlots(inventory, this.createFillerItem());
        if (startIndex > 0) {
            inventory.setItem(45, this.createNavigationItem("Previous Page"));
        }
        if (endIndex < bannedPlayers.size()) {
            inventory.setItem(53, this.createNavigationItem("Next Page"));
        }
    }

    private ItemStack createPlayerHeadItem(BanEntry banEntry) {
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)playerHead.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)UUID.fromString(banEntry.getTarget())));
            meta.setDisplayName(banEntry.getTarget());
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)("Reason: " + banEntry.getReason())));
            lore.add((CallSite)((Object)("Banned on: " + new SimpleDateFormat("yyyy-MM-dd").format(banEntry.getCreated()))));
            meta.setLore(lore);
            playerHead.setItemMeta((ItemMeta)meta);
        }
        return playerHead;
    }

    private ItemStack createFillerItem() {
        ItemStack item = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(" ");
            item.setItemMeta(meta);
        }
        return item;
    }

    private void fillEmptySlots(Inventory inventory, ItemStack fillerItem) {
        for (int i = 0; i < 45; ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, fillerItem);
        }
    }

    private ItemStack createNavigationItem(String name) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void playSound(Player player, Sound sound) {
        player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player admin = (Player)humanEntity;
        Inventory inventory = event.getInventory();
        if (!(inventory.getHolder() instanceof SelectPlayerInventoryHolder)) {
            return;
        }
        event.setCancelled(true);
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        ItemMeta itemMeta = currentItem.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        String itemName = itemMeta.getDisplayName();
        if (itemName.equals("Previous Page") || itemName.equals("Next Page")) {
            int page = this.getCurrentPage(inventory);
            page = itemName.equals("Previous Page") ? --page : ++page;
            this.populateInventoryWithBannedPlayers(inventory, page);
        } else {
            this.confirmUnban(admin, itemName);
        }
    }

    private int getCurrentPage(Inventory inventory) {
        ItemStack firstItem = inventory.getItem(0);
        if (firstItem != null && firstItem.hasItemMeta() && firstItem.getItemMeta().hasDisplayName()) {
            String string = firstItem.getItemMeta().getDisplayName();
        }
        return 0;
    }

    private void confirmUnban(Player admin, String playerName) {
        this.handlePlayerUnban(admin, playerName);
    }

    private void handlePlayerUnban(Player admin, String playerName) {
        BanList banList = Bukkit.getBanList((BanList.Type)BanList.Type.NAME);
        if (banList.isBanned(playerName)) {
            banList.pardon(playerName);
            admin.sendMessage(Component.text(playerName + " has been unbanned.").color(NamedTextColor.GREEN));
            this.playSound(admin, Sound.ENTITY_PLAYER_LEVELUP);
            admin.closeInventory();
        } else {
            admin.sendMessage(Component.text("Player " + playerName + " is not banned.").color(NamedTextColor.RED));
            this.playSound(admin, Sound.ENTITY_VILLAGER_NO);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().getHolder() instanceof SelectPlayerInventoryHolder) {
            // empty if block
        }
    }

    public static class SelectPlayerInventoryHolder
    implements InventoryHolder {
        @NotNull
        public Inventory getInventory() {
            return Bukkit.createInventory((InventoryHolder)this, (int)54);
        }
    }
}

