/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.commands;

import fanlim.dev.oaexploits.Oaexploits;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;

public class CommandBlocker
implements Listener {
    private final Oaexploits plugin;
    private Set<String> commandWhitelist;
    private Set<String> commandBlacklist;
    private boolean whitelistEnabled;
    private boolean blacklistEnabled;
    private boolean debugEnabled;

    public CommandBlocker(Oaexploits plugin) {
        this.plugin = plugin;
        this.reloadConfigValues();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage().toLowerCase().trim();
        String command = message.split(" ")[0].replaceFirst("^/+", "");
        if (event.getPlayer().isOp()) {
            return;
        }
        if (this.whitelistEnabled && !this.commandWhitelist.contains(command)) {
            this.cancelEvent(event, command, "whitelist");
            return;
        }
        if (this.blacklistEnabled && this.commandBlacklist.contains(command)) {
            this.cancelEvent(event, command, "blacklist");
            return;
        }
        if (this.isPluginsCommand(command) && this.blacklistEnabled) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.plugin.getPluginsCommandBlockedMessage() + "\nPlugins (0): []");
            this.logAttempt(event.getPlayer().getName(), command, "plugins command");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommandSend(PlayerCommandSendEvent event) {
        if (this.whitelistEnabled && !event.getPlayer().isOp()) {
            Set whitelistedCommands = this.commandWhitelist.stream().map(command -> command.startsWith("/") ? command.substring(1) : command).map(String::toLowerCase).collect(Collectors.toSet());
            event.getCommands().removeIf(command -> !whitelistedCommands.contains(command.toLowerCase()));
        }
    }

    private boolean isPluginsCommand(String command) {
        return command.matches(".*\\bplugins\\b.*");
    }

    private void logAttempt(String playerName, String command, String type) {
        if (this.debugEnabled) {
            this.plugin.getLogger().info("Player " + playerName + " tried to execute blocked " + type + " command: " + command);
        }
    }

    private void cancelEvent(PlayerCommandPreprocessEvent event, String command, String type) {
        event.setCancelled(true);
        this.logAttempt(event.getPlayer().getName(), command, type);
    }

    public void reloadConfigValues() {
        FileConfiguration config = this.plugin.getConfig();
        this.whitelistEnabled = config.getBoolean("command-whitelist.enabled", false);
        this.blacklistEnabled = config.getBoolean("command-blacklist.enabled", false);
        this.debugEnabled = config.getBoolean("debug-enabled", false);
        this.commandWhitelist = config.getStringList("command-whitelist.commands").stream().map(String::toLowerCase).collect(Collectors.toSet());
        if (this.commandWhitelist.isEmpty() && this.whitelistEnabled) {
            this.plugin.getLogger().warning("Command whitelist is empty or not set in the config.");
        }
        this.commandBlacklist = config.getStringList("command-blacklist.commands").stream().map(String::toLowerCase).collect(Collectors.toSet());
        if (this.commandBlacklist.isEmpty() && this.blacklistEnabled) {
            this.plugin.getLogger().warning("Command blacklist is empty or not set in the config.");
        }
        this.plugin.getLogger().log(Level.INFO, "CommandBlocker configuration reloaded. Whitelist enabled: {0}, Blacklist enabled: {1}, Debug enabled: {2}", new Object[]{this.whitelistEnabled, this.blacklistEnabled, this.debugEnabled});
        if (this.debugEnabled) {
            this.plugin.getLogger().info("Whitelist: " + String.valueOf(this.commandWhitelist));
            this.plugin.getLogger().info("Blacklist: " + String.valueOf(this.commandBlacklist));
        }
    }

    public void setDebugEnabled(boolean enabled) {
        this.debugEnabled = enabled;
        this.plugin.getLogger().log(Level.INFO, "Debug mode {0}", enabled ? "enabled" : "disabled");
    }
}

