/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.stats;

import fanlim.dev.oaexploits.Oaexploits;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class WorldStats
implements CommandExecutor,
Listener {
    private final Oaexploits plugin;
    private final ExecutorService executorService;
    private int newChunksLoaded;

    public WorldStats(Oaexploits plugin) {
        this.plugin = plugin;
        this.executorService = Executors.newCachedThreadPool();
        this.newChunksLoaded = 0;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (event.isNewChunk()) {
            ++this.newChunksLoaded;
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!command.getName().equalsIgnoreCase("worldstats")) {
            return false;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            String fetchingMessage = this.getWorldStatsConfig().getString("messages.fetching", "Fetching world stats...");
            player.sendMessage(Component.text(fetchingMessage).color(NamedTextColor.AQUA));
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.displayWorldStats(sender));
        return true;
    }

    private void displayWorldStats(CommandSender sender) {
        int playersJoined = Bukkit.getOfflinePlayers().length;
        CompletableFuture<Long> worldSizeFuture = this.calculateFolderSize("world");
        CompletableFuture<Long> netherSizeFuture = this.calculateFolderSize("world_nether");
        CompletableFuture<Long> endSizeFuture = this.calculateFolderSize("world_the_end");
        long worldSize = this.getFutureResult(worldSizeFuture);
        long netherSize = this.getFutureResult(netherSizeFuture);
        long endSize = this.getFutureResult(endSizeFuture);
        String serverStartDate = this.getServerStartDate(Bukkit.getWorld((String)"world"));
        Component message = this.buildStatsMessage(playersJoined, worldSize, netherSize, endSize, serverStartDate, this.newChunksLoaded);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            player.sendMessage(message);
        } else {
            Bukkit.getConsoleSender().sendMessage(LegacyComponentSerializer.legacyAmpersand().serialize(message));
        }
    }

    private CompletableFuture<Long> calculateFolderSize(String worldName) {
        return CompletableFuture.supplyAsync(() -> this.getFolderSize(Paths.get(Bukkit.getWorldContainer().getAbsolutePath(), worldName)), this.executorService);
    }

    private long getFutureResult(CompletableFuture<Long> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.plugin.getLogger().severe("Error calculating folder size: " + e.getMessage());
            return 0L;
        }
    }

    private long getFolderSize(Path folder) {
        AtomicLong size = new AtomicLong(0L);
        try (Stream files = (Stream)Files.walk(folder, new FileVisitOption[0]).parallel();){
            files.filter(p -> p.toFile().isFile()).forEach(p -> size.addAndGet(p.toFile().length()));
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Error reading folder size: " + e.getMessage());
        }
        return size.get();
    }

    private String formatSize(long size) {
        if (size >= 0x10000000000L) {
            return String.format("%.2f TB", (double)size / 1.099511627776E12);
        }
        if (size >= 0x40000000L) {
            return String.format("%.2f GB", (double)size / 1.073741824E9);
        }
        if (size >= 0x100000L) {
            return String.format("%.2f MB", (double)size / 1048576.0);
        }
        if (size >= 1024L) {
            return String.format("%.2f KB", (double)size / 1024.0);
        }
        return size + " B";
    }

    private String getServerStartDate(World world) {
        FileConfiguration config = this.getWorldStatsConfig();
        String configuredDate = config.getString("server-opening-date", null);
        if (configuredDate != null && !configuredDate.isEmpty()) {
            return configuredDate;
        }
        try {
            Path worldPath = world.getWorldFolder().toPath();
            BasicFileAttributes attr = Files.readAttributes(worldPath, BasicFileAttributes.class, new LinkOption[0]);
            LocalDate creationDate = attr.creationTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMMM dd, yyyy");
            return creationDate.format(formatter);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Error getting server start date: " + e.getMessage());
            return "Unknown";
        }
    }

    private Component buildStatsMessage(int playersJoined, long worldSize, long netherSize, long endSize, String serverStartDate, int newChunksLoaded) {
        FileConfiguration config = this.getWorldStatsConfig();
        TextComponent header = LegacyComponentSerializer.legacyAmpersand().deserialize(config.getString("messages.header", "&8&m----------------&6&lOpenAnarchy&8&m----------------"));
        TextComponent footer = LegacyComponentSerializer.legacyAmpersand().deserialize(config.getString("messages.footer", "&8&m----------------------------------------"));
        TextComponent playersJoinedMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(config.getString("messages.players-joined", "&6&lPlayer Stats\n&7- &e{players_joined} &7player(s) have spawned at least once in the world.").replace("{players_joined}", String.valueOf(playersJoined)));
        TextComponent worldSizeMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(config.getString("messages.world-size", "&6&lWorld Size\n&7- The world has a file size of &e{world_size}.").replace("{world_size}", this.formatSize(worldSize)));
        TextComponent netherSizeMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(config.getString("messages.nether-size", "&6&lNether Size\n&7- The Nether has a file size of &e{nether_size}.").replace("{nether_size}", this.formatSize(netherSize)));
        TextComponent endSizeMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(config.getString("messages.end-size", "&6&lEnd Size\n&7- The End has a file size of &e{end_size}.").replace("{end_size}", this.formatSize(endSize)));
        TextComponent serverStartDateMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(config.getString("messages.server-start-date", "&6&lServer Start Date\n&7- The server was opened on &e{server_start_date}.").replace("{server_start_date}", serverStartDate));
        TextComponent newChunksLoadedMessage = LegacyComponentSerializer.legacyAmpersand().deserialize(config.getString("messages.new-chunks-loaded", "&6&lNew Chunks Loaded\n&7- &e{new_chunks_loaded} &7new chunks have been loaded since the server started.").replace("{new_chunks_loaded}", String.valueOf(newChunksLoaded)));
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)header)).append((Component)Component.newline())).append((Component)playersJoinedMessage)).append((Component)Component.newline())).append((Component)worldSizeMessage)).append((Component)Component.newline())).append((Component)netherSizeMessage)).append((Component)Component.newline())).append((Component)endSizeMessage)).append((Component)Component.newline())).append((Component)serverStartDateMessage)).append((Component)Component.newline())).append((Component)newChunksLoadedMessage)).append((Component)Component.newline())).append((Component)footer)).build();
    }

    private FileConfiguration getWorldStatsConfig() {
        return this.plugin.getWorldStatsConfig();
    }
}

