/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.antiexploits;

import fanlim.dev.oaexploits.Oaexploits;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AntiIllegalItems
implements Listener {
    private final Oaexploits plugin;
    private final Set<Material> illegalItems = ConcurrentHashMap.newKeySet();
    private final Set<UUID> onlinePlayers = ConcurrentHashMap.newKeySet();
    private int inventoryScanDepth;
    private boolean adminAlertsEnabled;
    private int adminAlertCooldown;
    private long lastAdminAlertTime;
    private boolean removeIllegalItemsEnabled;
    private boolean cleanShulkersOnPlaceEnabled;
    private boolean notifyPlayerOnIllegalPlacementEnabled;
    private String illegalItemPlacementTitle;
    private String illegalItemPlacementSubtitle;
    private String illegalItemInteractionTitle;
    private String illegalItemInteractionSubtitle;
    private String illegalItemMovementSubtitle;
    private String illegalItemRemovalTitle;
    private String illegalItemRemovalSubtitle;
    private String adminAlertMessage;

    public AntiIllegalItems(Oaexploits plugin) {
        this.plugin = plugin;
        this.loadConfigValues();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void loadConfigValues() {
        FileConfiguration config = this.plugin.getConfig();
        this.loadIllegalItems(config.getStringList("illegal-items.blocks"));
        this.loadIllegalItems(config.getStringList("illegal-items.items"));
        this.inventoryScanDepth = config.getInt("additional-configs.inventory-scan-depth", 3);
        this.adminAlertsEnabled = config.getBoolean("admin-alerts.enabled", true);
        this.adminAlertCooldown = config.getInt("admin-alerts.cooldown", 60);
        this.lastAdminAlertTime = 0L;
        this.removeIllegalItemsEnabled = config.getBoolean("removal-options.remove-illegal-items", true);
        this.cleanShulkersOnPlaceEnabled = config.getBoolean("removal-options.clean-shulkers-on-place", true);
        this.notifyPlayerOnIllegalPlacementEnabled = config.getBoolean("removal-options.notify-player-on-illegal-placement", true);
        this.illegalItemPlacementTitle = config.getString("messages.illegal-item-placement.title", "&cIllegal Block!");
        this.illegalItemPlacementSubtitle = config.getString("messages.illegal-item-placement.subtitle", "&cYou cannot place that block!");
        this.illegalItemInteractionTitle = config.getString("messages.illegal-item-interaction.title", "&cIllegal Item!");
        this.illegalItemInteractionSubtitle = config.getString("messages.illegal-item-interaction.subtitle", "&cYou tried to interact with an illegal item: %item%");
        this.illegalItemMovementSubtitle = config.getString("messages.illegal-item-movement.subtitle", "&cContainer tried to move an illegal item: %item%");
        this.illegalItemRemovalTitle = config.getString("messages.illegal-item-removal.title", "&cIllegal Items Removed!");
        this.illegalItemRemovalSubtitle = config.getString("messages.illegal-item-removal.subtitle", "&cIllegal items were removed from your inventory.");
        this.adminAlertMessage = config.getString("messages.admin-alert", "&c%player% tried to interact with an illegal item: %item%");
    }

    private void loadIllegalItems(List<String> itemNames) {
        for (String itemName : itemNames) {
            try {
                Material material = Material.valueOf((String)itemName.toUpperCase());
                this.illegalItems.add(material);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid item name in config: " + itemName);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        this.handleItemInteraction(event.getCurrentItem(), event.getWhoClicked().getName());
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        this.handleItemMovement(event.getItem(), event.getSource(), event.getDestination());
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        this.handleInventoryOpen(event.getInventory(), event.getPlayer().getName());
    }

    @EventHandler
    public void onInventoryPickupItem(InventoryPickupItemEvent event) {
        this.handleItemInteraction(event.getItem().getItemStack(), "Container");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.onlinePlayers.add(playerId);
        this.checkPlayerInventory(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.onlinePlayers.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.handlePlayerInteract(event);
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        this.handleItemInteraction(event.getPlayer().getInventory().getItem(event.getNewSlot()), event.getPlayer().getName());
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        this.handleItemInteraction(event.getItemDrop().getItemStack(), event.getPlayer().getName());
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        this.handleBlockPlace(event);
    }

    @EventHandler
    private void handleEntityPickup(EntityPickupItemEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack item = event.getItem().getItemStack();
        if (this.shouldRemoveItem(item)) {
            int removedCount = item.getAmount();
            this.removeItem(item);
            this.alertAdminsIfPlayer((Entity)entity, item);
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from entity pickup by " + entity.getName() + "\u001b[0m");
        }
    }

    private void handleItemInteraction(ItemStack item, String playerName) {
        if (item != null && this.removeIllegalItemsEnabled && this.shouldRemoveItem(item)) {
            int removedCount = item.getAmount();
            this.removeItem(item);
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)this.illegalItemInteractionSubtitle.replace("%item%", item.getType().toString()));
            if (this.notifyPlayerOnIllegalPlacementEnabled) {
                this.sendTitleToPlayer(Bukkit.getPlayer((String)playerName), ChatColor.translateAlternateColorCodes((char)'&', (String)this.illegalItemInteractionTitle), message);
            }
            this.alertAdmins(ChatColor.translateAlternateColorCodes((char)'&', (String)(playerName + " " + message)));
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from player " + playerName + "\u001b[0m");
        }
    }

    private void handleItemMovement(ItemStack item, Inventory source, Inventory destination) {
        if (item != null && this.shouldRemoveItem(item)) {
            int removedCount = item.getAmount();
            this.removeItem(item);
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)this.illegalItemMovementSubtitle.replace("%item%", item.getType().toString()));
            this.alertAdmins(message);
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items during item movement\u001b[0m");
        }
        this.removeIllegalItems(source, this.inventoryScanDepth);
        this.removeIllegalItems(destination, this.inventoryScanDepth);
    }

    private void handleInventoryOpen(Inventory inventory, String playerName) {
        int removedCount = this.removeIllegalItems(inventory, this.inventoryScanDepth);
        if (removedCount > 0) {
            Player player = Bukkit.getPlayer((String)playerName);
            if (this.notifyPlayerOnIllegalPlacementEnabled) {
                this.sendTitleToPlayer(player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.illegalItemRemovalTitle), ChatColor.translateAlternateColorCodes((char)'&', (String)this.illegalItemRemovalSubtitle));
            }
            this.alertAdmins(ChatColor.translateAlternateColorCodes((char)'&', (String)(playerName + " " + this.illegalItemRemovalSubtitle)));
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from inventory of player " + playerName + "\u001b[0m");
        }
    }

    private void handlePlayerInteract(PlayerInteractEvent event) {
        Action action = event.getAction();
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (this.isRightOrLeftClick(action) && player.isSneaking() && this.isShulkerBox(item)) {
            this.handleShulkerBoxContents(item);
        }
    }

    private void handleShulkerBoxContents(ItemStack item) {
        ShulkerBox shulker;
        int removedCount;
        BlockState blockState;
        if (!this.removeIllegalItemsEnabled) {
            return;
        }
        BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
        if (meta != null && (blockState = meta.getBlockState()) instanceof ShulkerBox && (removedCount = this.removeIllegalItems((shulker = (ShulkerBox)blockState).getInventory(), this.inventoryScanDepth - 1)) > 0) {
            meta.setBlockState((BlockState)shulker);
            item.setItemMeta((ItemMeta)meta);
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from a Shulker Box.\u001b[0m");
        }
    }

    private boolean isRightOrLeftClick(Action action) {
        return action == Action.RIGHT_CLICK_BLOCK || action == Action.RIGHT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK || action == Action.LEFT_CLICK_AIR;
    }

    private void handleBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItemInHand();
        Material blockType = event.getBlock().getType();
        if (this.removeIllegalItemsEnabled && (this.shouldRemoveItem(item) || this.isIllegalBlock(blockType))) {
            event.setCancelled(true);
            int removedCount = item.getAmount();
            this.removeItem(item);
            if (this.notifyPlayerOnIllegalPlacementEnabled) {
                this.sendTitleToPlayer(player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.illegalItemPlacementTitle), ChatColor.translateAlternateColorCodes((char)'&', (String)this.illegalItemPlacementSubtitle));
            }
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)this.adminAlertMessage.replace("%player%", player.getName()).replace("%item%", item.getType().toString()));
            this.alertAdmins(message);
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from player " + player.getName() + "\u001b[0m");
        } else if (this.isShulkerBox(item) && this.cleanShulkersOnPlaceEnabled) {
            this.handleShulkerBoxContents(item);
        }
    }

    private boolean isIllegalBlock(Material blockType) {
        return this.illegalItems.contains(blockType);
    }

    private void checkPlayerInventory(Player player) {
        int removedCount = this.removeIllegalItems((Inventory)player.getInventory(), this.inventoryScanDepth);
        if (removedCount > 0) {
            if (this.notifyPlayerOnIllegalPlacementEnabled) {
                this.sendTitleToPlayer(player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.illegalItemRemovalTitle), ChatColor.translateAlternateColorCodes((char)'&', (String)this.illegalItemRemovalSubtitle));
            }
            this.alertAdmins(ChatColor.translateAlternateColorCodes((char)'&', (String)(player.getName() + " " + this.illegalItemRemovalSubtitle)));
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from player " + player.getName() + "\u001b[0m");
        }
    }

    private int removeIllegalItems(Inventory inventory, int depth) {
        if (depth < 1) {
            return 0;
        }
        int removedCount = 0;
        for (ItemStack item : inventory.getContents()) {
            if (item == null) continue;
            if (this.shouldRemoveItem(item)) {
                removedCount += item.getAmount();
                this.removeItem(item);
                continue;
            }
            if (!this.isShulkerBox(item) || depth <= 1) continue;
            removedCount += this.removeShulkerBoxContents(item, depth);
        }
        return removedCount;
    }

    private int removeShulkerBoxContents(ItemStack item, int depth) {
        ShulkerBox shulker;
        BlockState blockState;
        BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
        int removedCount = 0;
        if (meta != null && (blockState = meta.getBlockState()) instanceof ShulkerBox && (removedCount = this.removeIllegalItems((shulker = (ShulkerBox)blockState).getInventory(), depth - 1)) > 0) {
            meta.setBlockState((BlockState)shulker);
            item.setItemMeta((ItemMeta)meta);
        }
        return removedCount;
    }

    private void removeItem(ItemStack item) {
        item.setAmount(0);
    }

    private boolean isIllegalItem(ItemStack item) {
        return item != null && this.illegalItems.contains(item.getType());
    }

    private boolean shouldRemoveItem(ItemStack item) {
        return this.removeIllegalItemsEnabled && this.isIllegalItem(item);
    }

    private void alertAdmins(String message) {
        long currentTime = System.currentTimeMillis() / 1000L;
        if (this.adminAlertsEnabled && currentTime - this.lastAdminAlertTime >= (long)this.adminAlertCooldown) {
            this.lastAdminAlertTime = currentTime;
            Bukkit.getOnlinePlayers().stream().filter(player -> player.hasPermission("oaexploits.alerts")).forEach(player -> player.sendMessage(message));
        }
    }

    private void alertAdminsIfPlayer(Entity entity, ItemStack item) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)this.adminAlertMessage.replace("%player%", player.getName()).replace("%item%", item.getType().toString()));
            this.alertAdmins(message);
        }
    }

    private void sendTitleToPlayer(Player player, String title, String subtitle) {
        if (player != null && this.notifyPlayerOnIllegalPlacementEnabled) {
            TextComponent titleComponent = Component.text((String)ChatColor.translateAlternateColorCodes((char)'&', (String)title));
            TextComponent subtitleComponent = Component.text((String)ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle));
            Title playerTitle = Title.title((Component)titleComponent, (Component)subtitleComponent);
            player.showTitle(playerTitle);
        }
    }

    public Set<Material> getIllegalItems() {
        return this.illegalItems;
    }

    public int getInventoryScanDepth() {
        return this.inventoryScanDepth;
    }

    public void reloadConfigValues() {
        this.plugin.reloadConfig();
        this.loadConfigValues();
        this.plugin.getLogger().info("AntiIllegalItems configuration reloaded.");
    }

    private boolean isShulkerBox(ItemStack item) {
        return item != null && item.getType().toString().endsWith("_SHULKER_BOX");
    }
}

