/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.antiexploits;

import fanlim.dev.oaexploits.Oaexploits;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.ShulkerBox;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ChunkDataHandler
implements Listener {
    private final Oaexploits plugin;
    private final Set<Material> illegalItems;
    private int inventoryScanDepth;
    private boolean removeIllegalItems;
    private boolean removeIllegalsOnChunkLoad;

    public ChunkDataHandler(Oaexploits plugin, Set<Material> illegalItems, int inventoryScanDepth) {
        this.plugin = plugin;
        this.illegalItems = illegalItems;
        this.inventoryScanDepth = inventoryScanDepth;
        this.loadConfigValues();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void loadConfigValues() {
        FileConfiguration config = this.plugin.getConfig();
        this.removeIllegalItems = config.getBoolean("removal-options.remove-illegal-items", true);
        this.removeIllegalsOnChunkLoad = config.getBoolean("removal-options.remove-illegals-on-chunkload", false);
        this.inventoryScanDepth = config.getInt("removal-options.inventory-scan-depth", 3);
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (this.removeIllegalsOnChunkLoad) {
            CompletableFuture.runAsync(() -> {
                for (BlockState blockState : event.getChunk().getTileEntities()) {
                    try {
                        this.processBlockState(blockState);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Error processing container in chunk at " + event.getChunk().getX() + ", " + event.getChunk().getZ(), e);
                    }
                }
            });
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        BlockState blockState;
        if (this.removeIllegalItems && (blockState = event.getBlockPlaced().getState()) instanceof ShulkerBox) {
            ShulkerBox shulkerBox = (ShulkerBox)blockState;
            CompletableFuture.runAsync(() -> {
                try {
                    this.processContainer(shulkerBox.getInventory(), shulkerBox.getX(), shulkerBox.getY(), shulkerBox.getZ());
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Error processing placed Shulker Box at " + shulkerBox.getX() + ", " + shulkerBox.getY() + ", " + shulkerBox.getZ(), e);
                }
            });
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!this.removeIllegalItems) {
            return;
        }
        Inventory inventory = event.getInventory();
        InventoryHolder holder = inventory.getHolder();
        if (holder != null) {
            CompletableFuture.runAsync(() -> {
                try {
                    this.processInventoryHolder(holder, inventory, event.getPlayer().getLocation().getX(), event.getPlayer().getLocation().getY(), event.getPlayer().getLocation().getZ());
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Error processing inventory open event at " + event.getPlayer().getLocation().getX() + ", " + event.getPlayer().getLocation().getY() + ", " + event.getPlayer().getLocation().getZ(), e);
                }
            });
        }
    }

    private void processBlockState(BlockState blockState) {
        if (blockState instanceof Container) {
            Container container = (Container)blockState;
            this.processContainer(container.getInventory(), container.getX(), container.getY(), container.getZ());
        } else if (blockState instanceof ShulkerBox) {
            ShulkerBox shulker = (ShulkerBox)blockState;
            this.processContainer(shulker.getInventory(), shulker.getX(), shulker.getY(), shulker.getZ());
        }
    }

    private void processInventoryHolder(InventoryHolder holder, Inventory inventory, double x, double y, double z) {
        if (holder instanceof Container) {
            Container container = (Container)holder;
            this.processContainer(container.getInventory(), container.getX(), container.getY(), container.getZ());
        } else if (holder instanceof ShulkerBox) {
            ShulkerBox shulker = (ShulkerBox)holder;
            this.processContainer(shulker.getInventory(), shulker.getX(), shulker.getY(), shulker.getZ());
        } else {
            this.processContainer(inventory, x, y, z);
        }
    }

    private void processContainer(Inventory inventory, double x, double y, double z) {
        StringBuilder removedItemsReport = new StringBuilder();
        removedItemsReport.append("Removed illegal items from container at ").append(x).append(", ").append(y).append(", ").append(z).append(": ");
        if (this.removeIllegalItems(inventory, this.inventoryScanDepth - 1, removedItemsReport)) {
            this.logAndAlert(removedItemsReport.toString());
        }
    }

    private boolean removeIllegalItems(Inventory inventory, int depth, StringBuilder removedItemsReport) {
        ItemStack[] contents;
        if (depth < 1) {
            return false;
        }
        boolean itemsRemoved = false;
        for (ItemStack item : contents = inventory.getContents()) {
            if (item == null) continue;
            if (this.isIllegalItem(item)) {
                removedItemsReport.append(item.getType()).append(" ");
                this.removeItem(item);
                itemsRemoved = true;
                this.logIllegalItemRemoval(item);
                continue;
            }
            if (!item.getType().toString().endsWith("_SHULKER_BOX") || depth <= 1) continue;
            itemsRemoved |= this.removeShulkerBoxContents(item, depth, removedItemsReport);
        }
        if (itemsRemoved) {
            inventory.setContents(contents);
        }
        return itemsRemoved;
    }

    private boolean removeShulkerBoxContents(ItemStack item, int depth, StringBuilder removedItemsReport) {
        BlockStateMeta blockStateMeta;
        BlockState blockState;
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof BlockStateMeta && (blockState = (blockStateMeta = (BlockStateMeta)meta).getBlockState()) instanceof ShulkerBox) {
            ShulkerBox shulker = (ShulkerBox)blockState;
            boolean nestedItemsRemoved = this.removeIllegalItems(shulker.getInventory(), depth - 1, removedItemsReport);
            if (nestedItemsRemoved) {
                blockStateMeta.setBlockState((BlockState)shulker);
                item.setItemMeta((ItemMeta)blockStateMeta);
            }
            return nestedItemsRemoved;
        }
        return false;
    }

    private void removeItem(ItemStack item) {
        item.setAmount(0);
    }

    private boolean isIllegalItem(ItemStack item) {
        return item != null && this.illegalItems.contains(item.getType());
    }

    private void logIllegalItemRemoval(ItemStack item) {
        this.plugin.getLogger().log(Level.INFO, "Illegal item removed: " + String.valueOf(item.getType()));
    }

    private void logAndAlert(String message) {
        this.plugin.getLogger().info(message);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("oaexploits.alerts")) continue;
            player.sendMessage(String.valueOf(ChatColor.RED) + message);
        }
    }

    public void reloadConfigValues() {
        this.loadConfigValues();
        this.plugin.getLogger().info("Configuration reloaded.");
    }
}

