/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.commands;

import fanlim.dev.oaexploits.Oaexploits;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;

public class CommandBlocker
implements Listener {
    private final Oaexploits plugin;
    private final Map<String, Long> commandAttemptTimestamps = new HashMap<String, Long>();
    private static final long COMMAND_ATTEMPT_INTERVAL = 1000L;

    public CommandBlocker(Oaexploits plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage().toLowerCase().trim();
        String command = message.split(" ")[0].replaceAll("^/+", "");
        if (event.getPlayer().isOp()) {
            return;
        }
        if (this.isRateLimited(event.getPlayer().getName(), command)) {
            event.setCancelled(true);
            this.logAttempt(event.getPlayer().getName(), command, "rate limit");
            return;
        }
        if (this.plugin.isWhitelistEnabled() && !this.plugin.getCommandWhitelist().contains(command)) {
            event.setCancelled(true);
            this.logAttempt(event.getPlayer().getName(), command, "whitelist");
            return;
        }
        if (this.plugin.isBlacklistEnabled() && this.plugin.getCommandBlacklist().contains(command)) {
            event.setCancelled(true);
            this.logAttempt(event.getPlayer().getName(), command, "blacklist");
            return;
        }
        if (this.isPluginsCommand(command)) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.plugin.getPluginsCommandBlockedMessage() + "\nPlugins (0): []");
            this.logAttempt(event.getPlayer().getName(), command, "plugins command");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommandSend(PlayerCommandSendEvent event) {
        if (this.plugin.isWhitelistEnabled() && !event.getPlayer().isOp()) {
            Set whitelistedCommands = this.plugin.getCommandWhitelist().stream().map(command -> command.startsWith("/") ? command.substring(1) : command).collect(Collectors.toSet());
            event.getCommands().removeIf(command -> !whitelistedCommands.contains(command.toLowerCase()));
        }
    }

    private boolean isPluginsCommand(String command) {
        return command.equalsIgnoreCase("plugins") || command.equalsIgnoreCase("pl") || command.equalsIgnoreCase("bukkit:plugins") || command.equalsIgnoreCase("bukkit:pl") || command.equalsIgnoreCase("bukkit:?") || command.equalsIgnoreCase("bukkit:help") || command.equalsIgnoreCase(".plugins") || command.matches(".*[\\W_]*plugins[\\W_]*.*");
    }

    private boolean isRateLimited(String playerName, String command) {
        long lastAttempt;
        long currentTime = System.currentTimeMillis();
        String key = playerName + ":" + command;
        if (this.commandAttemptTimestamps.containsKey(key) && currentTime - (lastAttempt = this.commandAttemptTimestamps.get(key).longValue()) < 1000L) {
            return true;
        }
        this.commandAttemptTimestamps.put(key, currentTime);
        return false;
    }

    private void logAttempt(String playerName, String command, String type) {
        if (this.plugin.isDebugEnabled()) {
            this.plugin.getLogger().info("Player " + playerName + " tried to execute blocked " + type + " command: " + command);
        }
    }
}

