/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.discord;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class DiscordAlert {
    private final JavaPlugin plugin;
    private String webhookUrl;

    public DiscordAlert(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfigValues();
    }

    private void loadConfigValues() {
        FileConfiguration config = this.plugin.getConfig();
        this.webhookUrl = config.getString("discord-alerts.webhook-url");
        if (this.webhookUrl == null) {
            this.plugin.getLogger().severe("Discord webhook URL is not set in the config!");
        }
    }

    public void sendAlert(String title, String description, String footer, String itemName, int quantity, String action, String playerName) {
        if (this.webhookUrl != null) {
            CompletableFuture.runAsync(() -> {
                try (CloseableHttpClient client = HttpClients.createDefault();){
                    HttpPost post = new HttpPost(this.webhookUrl);
                    post.setHeader("Content-Type", "application/json");
                    JsonObject embed = new JsonObject();
                    embed.addProperty("title", title);
                    embed.addProperty("description", description);
                    embed.addProperty("color", (Number)15158332);
                    JsonArray fields = new JsonArray();
                    fields.add((JsonElement)this.createField("Player", playerName, true));
                    fields.add((JsonElement)this.createField("Action", action, true));
                    fields.add((JsonElement)this.createField("Item Removed", itemName, true));
                    fields.add((JsonElement)this.createField("Quantity", String.valueOf(quantity), true));
                    embed.add("fields", (JsonElement)fields);
                    JsonObject footerJson = new JsonObject();
                    footerJson.addProperty("text", footer + " \u2022 " + Instant.now().toString());
                    footerJson.addProperty("icon_url", "https://minotar.net/avatar/" + playerName + "/128");
                    embed.add("footer", (JsonElement)footerJson);
                    JsonObject author = new JsonObject();
                    author.addProperty("name", playerName);
                    author.addProperty("icon_url", "https://minotar.net/avatar/" + playerName + "/128");
                    embed.add("author", (JsonElement)author);
                    JsonObject json = new JsonObject();
                    json.add("embeds", (JsonElement)new JsonArray());
                    json.getAsJsonArray("embeds").add((JsonElement)embed);
                    post.setEntity(new StringEntity(json.toString()));
                    client.execute(post);
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to send Discord alert: " + e.getMessage(), e);
                }
            });
        } else {
            this.plugin.getLogger().severe("Webhook URL is not initialized. Cannot send message: " + title);
        }
    }

    private JsonObject createField(String name, String value, boolean inline) {
        JsonObject field = new JsonObject();
        field.addProperty("name", name);
        field.addProperty("value", value);
        field.addProperty("inline", Boolean.valueOf(inline));
        return field;
    }
}

