/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.illegalitems;

import fanlim.dev.oaexploits.Oaexploits;
import fanlim.dev.oaexploits.discord.DiscordAlert;
import fanlim.dev.oaexploits.oaexploitsgui.OaExploitsGUI;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class AntiIllegalItems
implements Listener,
CommandExecutor {
    private final Oaexploits plugin;
    private final Set<Material> illegalItems = ConcurrentHashMap.newKeySet();
    private final Set<UUID> onlinePlayers = ConcurrentHashMap.newKeySet();
    public final Set<UUID> addingIllegalItems = ConcurrentHashMap.newKeySet();
    private final DiscordAlert discordAlert;
    private int inventoryScanDepth;
    private boolean adminAlertsEnabled;
    private int adminAlertCooldown;
    private long lastAdminAlertTime;
    private boolean removeIllegalItemsEnabled;
    private boolean cleanShulkersOnPlaceEnabled;
    private boolean notifyPlayerOnIllegalPlacementEnabled;
    private String illegalItemPlacementTitle;
    private String illegalItemPlacementSubtitle;
    private String illegalItemInteractionTitle;
    private String illegalItemInteractionSubtitle;
    private String illegalItemRemovalTitle;
    private String illegalItemRemovalSubtitle;
    private String adminAlertMessage;
    private File logFile;

    public AntiIllegalItems(Oaexploits plugin) {
        this.plugin = plugin;
        this.discordAlert = new DiscordAlert(plugin);
        this.loadConfigValues();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        if (plugin.getCommand("listillegalitems") != null) {
            Objects.requireNonNull(plugin.getCommand("listillegalitems")).setExecutor((CommandExecutor)this);
        }
        this.initializeLogFile();
    }

    private void loadConfigValues() {
        FileConfiguration config = this.plugin.getConfig();
        this.loadIllegalItems(config.getStringList("illegal-items.blocks"));
        this.inventoryScanDepth = config.getInt("additional-configs.inventory-scan-depth", 10);
        this.adminAlertsEnabled = config.getBoolean("admin-alerts.enabled", true);
        this.adminAlertCooldown = config.getInt("admin-alerts.cooldown", 30);
        this.lastAdminAlertTime = 0L;
        this.removeIllegalItemsEnabled = config.getBoolean("removal-options.remove-illegal-items", true);
        this.cleanShulkersOnPlaceEnabled = config.getBoolean("removal-options.clean-shulkers-on-place", true);
        this.notifyPlayerOnIllegalPlacementEnabled = config.getBoolean("removal-options.notify-player-on-illegal-placement", true);
        this.illegalItemPlacementTitle = this.translateColorCodes(config.getString("messages.illegal-item-placement.title", "&cIllegal Block!"));
        this.illegalItemPlacementSubtitle = this.translateColorCodes(config.getString("messages.illegal-item-placement.subtitle", "&cYou cannot place that block!"));
        this.illegalItemInteractionTitle = this.translateColorCodes(config.getString("messages.illegal-item-interaction.title", "&cIllegal Item!"));
        this.illegalItemInteractionSubtitle = this.translateColorCodes(config.getString("messages.illegal-item-interaction.subtitle", "&cYou tried to interact with an illegal item: %item%"));
        this.illegalItemRemovalTitle = this.translateColorCodes(config.getString("messages.illegal-item-removal.title", "&cIllegal Items Removed!"));
        this.illegalItemRemovalSubtitle = this.translateColorCodes(config.getString("messages.illegal-item-removal.subtitle", "&cIllegal items were removed from your inventory."));
        this.adminAlertMessage = this.translateColorCodes(config.getString("messages.admin-alert", "&c%player% tried to interact with an illegal item: %item%"));
    }

    private void initializeLogFile() {
        this.logFile = new File(this.plugin.getDataFolder(), "illegal_items.log");
        try {
            if (!this.logFile.exists() && !this.logFile.createNewFile()) {
                this.plugin.getLogger().severe("Could not create log file.");
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not create log file: " + e.getMessage());
        }
    }

    private void logIllegalItemInteraction(String message) {
        try (FileWriter writer = new FileWriter(this.logFile, true);){
            String logMessage = "[" + String.valueOf(LocalDateTime.now()) + "] " + message;
            writer.write(logMessage + "\n");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not write to log file: " + e.getMessage());
        }
    }

    private String translateColorCodes(String message) {
        return message.replace("&", "\u00a7");
    }

    private void loadIllegalItems(List<String> itemNames) {
        for (String itemName : itemNames) {
            try {
                Material material = Material.valueOf((String)itemName.toUpperCase());
                this.illegalItems.add(material);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid item name in config: " + itemName);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player;
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player && this.addingIllegalItems.contains((player = (Player)humanEntity).getUniqueId())) {
            return;
        }
        this.handleItemInteraction(event.getCurrentItem(), event.getWhoClicked(), "click");
        this.handleItemInteraction(event.getCursor(), event.getWhoClicked(), "cursor");
        if (event.getClickedInventory() != null) {
            this.crossInventoryCheck(event.getClickedInventory(), event.getWhoClicked());
        }
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        this.handleItemMovement(event.getItem(), event.getSource(), event.getDestination());
        this.scanInventoryForIllegalItems(event.getSource());
        this.scanInventoryForIllegalItems(event.getDestination());
        this.crossInventoryCheck(event.getSource(), event.getInitiator());
        this.crossInventoryCheck(event.getDestination(), event.getInitiator());
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getInventory().getHolder() instanceof OaExploitsGUI.OaExploitsInventoryHolder)) {
            this.handleInventoryOpen(event.getInventory(), (Player)event.getPlayer());
        }
    }

    @EventHandler
    public void onInventoryPickupItem(InventoryPickupItemEvent event) {
        this.handleItemInteraction(event.getItem().getItemStack(), "Container", "pickup");
        this.crossInventoryCheck(event.getInventory(), null);
    }

    @EventHandler
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        this.handleItemInteraction(event.getItem().getItemStack(), event.getEntity(), "pickup");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.onlinePlayers.add(playerId);
        this.checkPlayerInventory(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.onlinePlayers.remove(event.getPlayer().getUniqueId());
        this.addingIllegalItems.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Action action = event.getAction();
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (action == Action.RIGHT_CLICK_BLOCK || action == Action.RIGHT_CLICK_AIR) {
            this.handleItemInteraction(item, player, "interact");
        }
        if (player.isSneaking() && this.isShulkerBox(item)) {
            this.handleShulkerBoxContents(item);
        }
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        this.handleItemInteraction(event.getPlayer().getInventory().getItem(event.getNewSlot()), event.getPlayer(), "held");
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        this.handleItemInteraction(event.getItemDrop().getItemStack(), event.getPlayer(), "drop");
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        this.handleBlockPlace(event);
    }

    private void handleItemInteraction(ItemStack item, Object entity, String action) {
        if (entity instanceof Player && ((Player)entity).hasPermission("oaexploits.bypass")) {
            return;
        }
        if (item != null && this.shouldRemoveItem(item)) {
            int removedCount = item.getAmount();
            Material itemType = item.getType();
            String itemTypeString = itemType.toString();
            this.removeItem(item);
            this.notifyEntityAndAdmins(entity, itemTypeString, removedCount, action);
            this.logIllegalItemInteraction("Removed " + removedCount + " illegal items from " + (entity instanceof Player ? "player " + ((Player)entity).getName() : "entity " + String.valueOf(entity)));
        }
    }

    private void handleItemMovement(ItemStack item, Inventory ignoredSource, Inventory ignoredDestination) {
        if (item != null && this.shouldRemoveItem(item)) {
            int removedCount = item.getAmount();
            Material itemType = item.getType();
            String itemTypeString = itemType.toString();
            this.removeItem(item);
            this.alertAdmins("Removed " + removedCount + " illegal items during item movement: " + itemTypeString);
            this.logIllegalItemInteraction("Removed " + removedCount + " illegal items during item movement");
        }
    }

    private void handleInventoryOpen(Inventory inventory, Player player) {
        if (player.hasPermission("oaexploits.bypass")) {
            return;
        }
        int removedCount = this.removeIllegalItems(inventory);
        if (removedCount > 0) {
            this.notifyPlayerAndAdmins(player, this.illegalItemRemovalTitle, this.illegalItemRemovalSubtitle, null);
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            this.logIllegalItemInteraction("Removed " + removedCount + " illegal items from inventory of player " + player.getName());
        }
    }

    private void handleShulkerBoxContents(ItemStack item) {
        ShulkerBox shulker;
        int removedCount;
        BlockState blockState;
        if (!this.removeIllegalItemsEnabled) {
            return;
        }
        BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
        if (meta != null && (blockState = meta.getBlockState()) instanceof ShulkerBox && (removedCount = this.removeIllegalItems((shulker = (ShulkerBox)blockState).getInventory())) > 0) {
            meta.setBlockState((BlockState)shulker);
            item.setItemMeta((ItemMeta)meta);
            this.logIllegalItemInteraction("Removed " + removedCount + " illegal items from a Shulker Box.");
        }
    }

    private void handleBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItemInHand();
        Material blockType = event.getBlock().getType();
        if (player.hasPermission("oaexploits.bypass")) {
            return;
        }
        if (this.removeIllegalItemsEnabled && (this.shouldRemoveItem(item) || this.isIllegalBlock(blockType))) {
            event.setCancelled(true);
            int removedCount = item.getAmount();
            Material itemType = item.getType();
            String itemTypeString = itemType.toString();
            this.removeItem(item);
            this.notifyPlayerAndAdmins(player, this.illegalItemPlacementTitle, this.illegalItemPlacementSubtitle.replace("%item%", blockType.toString()), itemTypeString);
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            this.logIllegalItemInteraction("Removed " + removedCount + " illegal items from player " + player.getName());
            this.checkPlayerInventory(player);
        } else if (this.isShulkerBox(item) && this.cleanShulkersOnPlaceEnabled) {
            this.handleShulkerBoxContents(item);
        }
    }

    private void notifyEntityAndAdmins(Object entity, String itemType, int quantity, String action) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.notifyPlayerAndAdmins(player, this.illegalItemInteractionTitle, this.illegalItemInteractionSubtitle.replace("%item%", itemType), itemType);
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            this.checkPlayerInventory(player);
        }
        if (entity instanceof Entity) {
            Entity ent = (Entity)entity;
            this.alertAdminsIfPlayer(ent, itemType, quantity, action);
        }
    }

    private void notifyPlayerAndAdmins(Player player, String title, String subtitle, String itemType) {
        if (player != null && this.notifyPlayerOnIllegalPlacementEnabled) {
            String subtitleMessage = subtitle.replace("%item%", itemType);
            this.sendTitleToPlayer(player, title, subtitleMessage);
            String adminMessage = this.adminAlertMessage.replace("%player%", player.getName()).replace("%item%", itemType);
            this.alertAdmins(adminMessage);
        }
    }

    private void alertAdmins(Player player, String itemName, int quantity, String action) {
        long currentTime = System.currentTimeMillis() / 1000L;
        if (this.adminAlertsEnabled && currentTime - this.lastAdminAlertTime >= (long)this.adminAlertCooldown) {
            this.lastAdminAlertTime = currentTime;
            String message = player.getName() + " tried to " + action + " " + quantity + " illegal items: " + itemName;
            Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("oaexploits.alerts")).forEach(p -> p.sendMessage(message));
            this.discordAlert.sendAlert("Illegal Activity Detected", message, "OAExploits Alert System", itemName, quantity, action, player.getName());
        }
    }

    private void alertAdminsIfPlayer(Entity entity, String itemType, int quantity, String action) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.alertAdmins(player, itemType, quantity, action);
        }
    }

    private void alertAdmins(String message) {
        Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("oaexploits.alerts")).forEach(p -> p.sendMessage(message));
    }

    private void sendTitleToPlayer(Player player, String title, String subtitle) {
        TextComponent titleComponent = Component.text(title);
        TextComponent subtitleComponent = Component.text(subtitle);
        Title playerTitle = Title.title(titleComponent, subtitleComponent);
        player.showTitle(playerTitle);
    }

    private void removeItem(ItemStack item) {
        item.setAmount(0);
    }

    private boolean isShulkerBox(ItemStack item) {
        return item != null && item.getType().toString().endsWith("_SHULKER_BOX");
    }

    private boolean isIllegalBlock(Material blockType) {
        return this.illegalItems.contains(blockType);
    }

    private boolean isIllegalItem(ItemStack item) {
        return item != null && this.illegalItems.contains(item.getType());
    }

    private boolean shouldRemoveItem(ItemStack item) {
        return this.removeIllegalItemsEnabled && this.isIllegalItem(item);
    }

    private void checkPlayerInventory(Player player) {
        if (player.hasPermission("oaexploits.bypass")) {
            return;
        }
        int removedCount = this.removeIllegalItems((Inventory)player.getInventory());
        if (removedCount > 0) {
            this.notifyPlayerAndAdmins(player, this.illegalItemRemovalTitle, this.illegalItemRemovalSubtitle, null);
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            this.logIllegalItemInteraction("Removed " + removedCount + " illegal items from player " + player.getName());
        }
    }

    private int removeIllegalItems(Inventory inventory) {
        return this.scanInventoryForIllegalItems(inventory);
    }

    private int scanInventoryForIllegalItems(Inventory inventory) {
        return this.scanInventoryForIllegalItems(inventory, this.inventoryScanDepth);
    }

    private int scanInventoryForIllegalItems(Inventory inventory, int depth) {
        if (depth < 1) {
            return 0;
        }
        int removedCount = 0;
        for (ItemStack item : inventory.getContents()) {
            if (item == null) continue;
            if (this.shouldRemoveItem(item)) {
                removedCount += item.getAmount();
                this.removeItem(item);
                continue;
            }
            if (!this.isShulkerBox(item) || depth <= 1) continue;
            removedCount += this.removeShulkerBoxContents(item, depth - 1);
        }
        return removedCount;
    }

    private int removeShulkerBoxContents(ItemStack item, int depth) {
        ShulkerBox shulker;
        BlockState blockState;
        BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
        int removedCount = 0;
        if (meta != null && (blockState = meta.getBlockState()) instanceof ShulkerBox && (removedCount = this.scanInventoryForIllegalItems((shulker = (ShulkerBox)blockState).getInventory(), depth - 1)) > 0) {
            meta.setBlockState((BlockState)shulker);
            item.setItemMeta((ItemMeta)meta);
        }
        return removedCount;
    }

    private void crossInventoryCheck(Inventory inventory, Object initiator) {
        int removedCount;
        if (inventory != null && (removedCount = this.scanInventoryForIllegalItems(inventory)) > 0 && initiator instanceof Player) {
            Player player = (Player)initiator;
            this.notifyPlayerAndAdmins(player, this.illegalItemRemovalTitle, this.illegalItemRemovalSubtitle, null);
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            this.logIllegalItemInteraction("Removed " + removedCount + " illegal items during cross-inventory check by player " + player.getName());
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (command.getName().equalsIgnoreCase("listillegalitems")) {
            if (sender.hasPermission("oaexploits.listillegalitems")) {
                sender.sendMessage("Illegal Items: " + String.valueOf(this.illegalItems));
                return true;
            }
            sender.sendMessage("You do not have permission to use this command.");
            return false;
        }
        return false;
    }

    public void reloadConfigValues() {
        this.loadConfigValues();
    }
}

