/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.players;

import fanlim.dev.oaexploits.Oaexploits;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDeopOnLeave
implements Listener {
    private final Oaexploits plugin;
    private FileConfiguration config;

    public PlayerDeopOnLeave(Oaexploits plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.handlePlayerDeop(event.getPlayer());
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        this.handlePlayerDeop(event.getPlayer());
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin().equals((Object)this.plugin)) {
            this.handleAllOnlinePlayers();
        }
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
        this.handleAllOnlinePlayers();
    }

    private void handlePlayerDeop(Player player) {
        if (!this.isDeopOnLeaveEnabled()) {
            return;
        }
        Set<String> whitelist = this.getWhitelist();
        if (this.shouldDeopPlayer(player, whitelist)) {
            this.deopPlayer(player);
        }
    }

    private boolean isDeopOnLeaveEnabled() {
        return this.config.getBoolean("deop-on-leave.enabled", true);
    }

    private Set<String> getWhitelist() {
        return this.config.getStringList("deop-on-leave.whitelist.players").stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    private boolean shouldDeopPlayer(Player player, Set<String> whitelist) {
        return player.isOp() && !whitelist.contains(player.getName().toLowerCase());
    }

    private void deopPlayer(Player player) {
        this.logDeopAction(player);
        player.setOp(false);
        player.getInventory().clear();
        this.teleportPlayerToSpawn(player);
        player.setGameMode(GameMode.SURVIVAL);
        this.sendMessageToPlayer(player);
    }

    private void logDeopAction(Player player) {
        this.plugin.getLogger().log(Level.INFO, "Deopping player {0} and clearing inventory on leave.", player.getName());
    }

    private void teleportPlayerToSpawn(Player player) {
        this.getTargetLocation().ifPresentOrElse(arg_0 -> ((Player)player).teleport(arg_0), () -> this.plugin.getLogger().warning("Failed to teleport player " + player.getName() + " to the configured location."));
    }

    private Optional<Location> getTargetLocation() {
        String worldName = this.config.getString("deop-on-leave.teleport.world");
        if (worldName == null) {
            this.plugin.getLogger().warning("World name for deop teleport location is not configured.");
            return Optional.empty();
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            this.plugin.getLogger().warning("World '" + worldName + "' for deop teleport location does not exist.");
            return Optional.empty();
        }
        double x = this.config.getDouble("deop-on-leave.teleport.x", 0.0);
        double y = this.config.getDouble("deop-on-leave.teleport.y", 64.0);
        double z = this.config.getDouble("deop-on-leave.teleport.z", 0.0);
        float yaw = (float)this.config.getDouble("deop-on-leave.teleport.yaw", 0.0);
        float pitch = (float)this.config.getDouble("deop-on-leave.teleport.pitch", 0.0);
        return Optional.of(new Location(world, x, y, z, yaw, pitch));
    }

    private void sendMessageToPlayer(Player player) {
        String message = this.config.getString("deop-on-leave.message", "&cYou have been deopped, your inventory cleared, and you have been teleported to the spawn point.");
        TextComponent textComponent = Component.text(message);
        player.sendMessage((Component)textComponent);
        Title title = Title.title(Component.text("Deopped"), Component.text("You have been deopped and teleported to the spawn point."), Title.Times.times(Duration.ofSeconds(1L), Duration.ofSeconds(3L), Duration.ofSeconds(1L)));
        player.showTitle(title);
    }

    public void handleAllOnlinePlayers() {
        if (!this.isDeopOnLeaveEnabled()) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(this::handlePlayerDeop);
    }

    public void reloadConfigValues() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.plugin.getLogger().info("PlayerDeopOnLeave configuration reloaded.");
    }
}

