/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.updates;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.JSONObject;

public class UpdateChecker {
    private static final String CONFIG_SPIGOT_RESOURCE_ID = System.getenv().getOrDefault("SPIGOT_RESOURCE_ID", "117670");
    private static final String CONFIG_UPDATE_URL = System.getenv().getOrDefault("UPDATE_URL", "https://api.spigotmc.org/simple/0.1/index.php?action=getResource&id=") + CONFIG_SPIGOT_RESOURCE_ID;
    private final JavaPlugin plugin;
    private final HttpClient httpClient;

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        this.httpClient = HttpClient.newHttpClient();
    }

    public void checkForUpdates() {
        CompletableFuture.runAsync(this::performUpdateCheck);
    }

    private void performUpdateCheck() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(CONFIG_UPDATE_URL)).build();
        ((CompletableFuture)((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(this::handleResponse)).exceptionally(e -> {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to check for updates", (Throwable)e);
            return null;
        });
    }

    private void handleResponse(String responseBody) {
        try {
            JSONObject jsonObject = new JSONObject(responseBody);
            if (!jsonObject.has("current_version")) {
                this.plugin.getLogger().log(Level.SEVERE, "Invalid response received: " + responseBody);
                return;
            }
            String latestVersion = jsonObject.getString("current_version").replace("oaexploits.", "");
            String currentVersion = this.plugin.getDescription().getVersion();
            this.logVersionInfo(currentVersion, latestVersion);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to process update response", e);
        }
    }

    private void logVersionInfo(String currentVersion, String latestVersion) {
        if (!currentVersion.equals(latestVersion)) {
            this.plugin.getLogger().info("\u001b[33m##############################################################\u001b[0m");
            this.plugin.getLogger().info("\u001b[33m#\u001b[0m");
            this.plugin.getLogger().info("\u001b[33m#   \u001b[31m\u26a0\ufe0f  NEW VERSION AVAILABLE! \u26a0\ufe0f\u001b[0m");
            this.plugin.getLogger().info("\u001b[33m#\u001b[0m");
            this.plugin.getLogger().info(String.format("\u001b[33m#   \u001b[34mLatest version:\u001b[32m %s\u001b[33m\u001b[0m", latestVersion));
            this.plugin.getLogger().info(String.format("\u001b[33m#   \u001b[34mCurrent version:\u001b[32m %s\u001b[33m\u001b[0m", currentVersion));
            this.plugin.getLogger().info("\u001b[33m#\u001b[0m");
            this.plugin.getLogger().info("\u001b[33m#   \u001b[31mPlease update to enjoy the latest features!\u001b[33m\u001b[0m");
            this.plugin.getLogger().info("\u001b[33m#\u001b[0m");
            this.plugin.getLogger().info("\u001b[33m##############################################################\u001b[0m");
        } else {
            this.plugin.getLogger().info("\u001b[32m##############################################################\u001b[0m");
            this.plugin.getLogger().info("\u001b[32m#\u001b[0m");
            this.plugin.getLogger().info("\u001b[32m#   \u2705 OaExploits is up to date! \u2705\u001b[0m");
            this.plugin.getLogger().info("\u001b[32m#\u001b[0m");
            this.plugin.getLogger().info(String.format("\u001b[32m#   \u001b[34mCurrent version:\u001b[32m %s\u001b[32m\u001b[0m", currentVersion));
            this.plugin.getLogger().info("\u001b[32m#\u001b[0m");
            this.plugin.getLogger().info("\u001b[32m##############################################################\u001b[0m");
        }
    }
}

