/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.chunks;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChunkLimiter
implements Listener {
    private final JavaPlugin plugin;
    private final Map<Material, Integer> blockLimits = new HashMap<Material, Integer>();
    private final Map<Chunk, Map<Material, Integer>> chunkBlockCounts = new HashMap<Chunk, Map<Material, Integer>>();
    private String blockLimitExceededMessage;
    private final Logger logger;

    public ChunkLimiter(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.blockLimits.clear();
        this.chunkBlockCounts.clear();
        Set keys = config.getConfigurationSection("chunk-limiter.limits").getKeys(false);
        for (String key : keys) {
            try {
                Material material = Material.valueOf((String)key.toUpperCase());
                int limit = config.getInt("chunk-limiter.limits." + key);
                this.blockLimits.put(material, limit);
            }
            catch (IllegalArgumentException e) {
                this.logger.warning("Invalid block type in config: " + key);
            }
        }
        this.blockLimitExceededMessage = config.getString("chunk-limiter.messages.block-limit-exceeded", "You cannot place more than {limit} {block} blocks in this chunk.");
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        Material material = block.getType();
        Player player = event.getPlayer();
        Chunk chunk = block.getChunk();
        if (this.blockLimits.containsKey(material)) {
            int limit = this.blockLimits.get(material);
            int currentCount = this.getBlockCountInChunk(chunk, material);
            if (currentCount >= limit) {
                event.setCancelled(true);
                player.sendMessage(this.formatMessage(this.blockLimitExceededMessage, limit, material));
                this.logger.info(String.format("%s attempted to place %s exceeding the limit in chunk %s", player.getName(), material, chunk.toString()));
            } else {
                this.incrementBlockCount(chunk, material);
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Material material = block.getType();
        Chunk chunk = block.getChunk();
        if (this.blockLimits.containsKey(material)) {
            this.decrementBlockCount(chunk, material);
        }
    }

    @EventHandler
    public void TntExplodeEvent(ExplosionPrimeEvent event) {
        Chunk chunk = event.getEntity().getChunk();
        Material material = Material.getMaterial((String)event.getEntityType().name());
        if (material != null && this.blockLimits.containsKey(material)) {
            this.decrementBlockCount(chunk, material);
        }
    }

    private int getBlockCountInChunk(Chunk chunk, Material material) {
        Map<Material, Integer> materialCounts;
        if (!this.chunkBlockCounts.containsKey(chunk)) {
            this.chunkBlockCounts.put(chunk, new HashMap());
        }
        if (!(materialCounts = this.chunkBlockCounts.get(chunk)).containsKey(material)) {
            materialCounts.put(material, this.countBlocksInChunk(chunk, material));
        }
        return materialCounts.get(material) - 1;
    }

    private void incrementBlockCount(Chunk chunk, Material material) {
        this.chunkBlockCounts.get(chunk).merge(material, 1, Integer::sum);
    }

    private void decrementBlockCount(Chunk chunk, Material material) {
        this.chunkBlockCounts.computeIfAbsent(chunk, k -> new HashMap());
        this.chunkBlockCounts.get(chunk).merge(material, -1, Integer::sum);
    }

    private int countBlocksInChunk(Chunk chunk, Material material) {
        int count = 0;
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < chunk.getWorld().getMaxHeight(); ++y) {
                for (int z = 0; z < 16; ++z) {
                    Block block = chunk.getBlock(x, y, z);
                    if (block.getType() != material) continue;
                    this.logger.info(String.format("Material is %s and count is %s", material.toString(), count + 1));
                    ++count;
                }
            }
        }
        return count;
    }

    private String formatMessage(String message, int limit, Material material) {
        return message.replace("{limit}", String.valueOf(limit)).replace("{block}", material.toString());
    }

    public void reloadChunkLimiterConfig() {
        this.plugin.reloadConfig();
        this.loadConfig();
        this.logger.info("ChunkLimiter configuration reloaded.");
    }
}

