/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.players;

import fanlim.dev.oaexploits.Oaexploits;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDeopOnLeave
implements Listener {
    private final Oaexploits plugin;

    public PlayerDeopOnLeave(Oaexploits plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.handlePlayerDeop(event.getPlayer());
    }

    @EventHandler
    public void onPlayerKick(PlayerKickEvent event) {
        this.handlePlayerDeop(event.getPlayer());
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin().equals((Object)this.plugin)) {
            this.handleAllOnlinePlayers();
        }
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
        this.handleAllOnlinePlayers();
    }

    public void handlePlayerDeop(Player player) {
        FileConfiguration config = this.plugin.getConfig();
        if (!this.isDeopOnLeaveEnabled(config)) {
            return;
        }
        Set<String> whitelist = this.getWhitelist(config);
        if (this.shouldDeopPlayer(player, whitelist)) {
            this.logDeopAction(player);
            this.deopPlayer(player, config);
        }
    }

    private boolean isDeopOnLeaveEnabled(FileConfiguration config) {
        return config.getBoolean("deop-on-leave.enabled");
    }

    private Set<String> getWhitelist(FileConfiguration config) {
        return config.getStringList("deop-on-leave.whitelist.players").stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    private boolean shouldDeopPlayer(Player player, Set<String> whitelist) {
        return player.isOp() && !whitelist.contains(player.getName().toLowerCase());
    }

    private void logDeopAction(Player player) {
        this.plugin.getLogger().log(Level.INFO, "Deopping player {0} and clearing inventory on leave.", player.getName());
    }

    private void deopPlayer(Player player, FileConfiguration config) {
        player.setOp(false);
        player.getInventory().clear();
        player.teleport(this.getTargetLocation(config));
        player.setGameMode(GameMode.SURVIVAL);
        String message = config.getString("deop-on-leave.message", "&cYou have been deopped, your inventory cleared, and you have been teleported to the spawn point.");
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    private Location getTargetLocation(FileConfiguration config) {
        String worldName = config.getString("deop-on-leave.teleport.world", "world");
        double x = config.getDouble("deop-on-leave.teleport.x", 0.0);
        double y = config.getDouble("deop-on-leave.teleport.y", 64.0);
        double z = config.getDouble("deop-on-leave.teleport.z", 0.0);
        float yaw = (float)config.getDouble("deop-on-leave.teleport.yaw", 0.0);
        float pitch = (float)config.getDouble("deop-on-leave.teleport.pitch", 0.0);
        return new Location(Bukkit.getWorld((String)worldName), x, y, z, yaw, pitch);
    }

    public void handleAllOnlinePlayers() {
        Bukkit.getOnlinePlayers().forEach(this::handlePlayerDeop);
    }

    public void reloadConfigValues() {
        this.plugin.reloadConfig();
        this.plugin.getLogger().info("PlayerDeopOnLeave configuration reloaded.");
    }
}

