/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.antiexploits;

import fanlim.dev.oaexploits.Oaexploits;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AntiIllegalItems
implements Listener {
    private final Oaexploits plugin;
    private final Set<Material> illegalItems = ConcurrentHashMap.newKeySet();
    private final Set<UUID> onlinePlayers = ConcurrentHashMap.newKeySet();
    public final Set<UUID> addingIllegalItems = ConcurrentHashMap.newKeySet();
    private int inventoryScanDepth;
    private boolean adminAlertsEnabled;
    private int adminAlertCooldown;
    private long lastAdminAlertTime;
    private boolean removeIllegalItemsEnabled;
    private boolean cleanShulkersOnPlaceEnabled;
    private boolean notifyPlayerOnIllegalPlacementEnabled;
    private String illegalItemPlacementTitle;
    private String illegalItemPlacementSubtitle;
    private String illegalItemInteractionTitle;
    private String illegalItemInteractionSubtitle;
    private String illegalItemMovementSubtitle;
    private String illegalItemRemovalTitle;
    private String illegalItemRemovalSubtitle;
    private String adminAlertMessage;

    public AntiIllegalItems(Oaexploits plugin) {
        this.plugin = plugin;
        this.loadConfigValues();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void loadConfigValues() {
        FileConfiguration config = this.plugin.getConfig();
        this.loadIllegalItems(config.getStringList("illegal-items.blocks"));
        this.inventoryScanDepth = config.getInt("additional-configs.inventory-scan-depth", 3);
        this.adminAlertsEnabled = config.getBoolean("admin-alerts.enabled", true);
        this.adminAlertCooldown = config.getInt("admin-alerts.cooldown", 60);
        this.lastAdminAlertTime = 0L;
        this.removeIllegalItemsEnabled = config.getBoolean("removal-options.remove-illegal-items", true);
        this.cleanShulkersOnPlaceEnabled = config.getBoolean("removal-options.clean-shulkers-on-place", true);
        this.notifyPlayerOnIllegalPlacementEnabled = config.getBoolean("removal-options.notify-player-on-illegal-placement", true);
        this.illegalItemPlacementTitle = this.translateColorCodes(config.getString("messages.illegal-item-placement.title", "&cIllegal Block!"));
        this.illegalItemPlacementSubtitle = this.translateColorCodes(config.getString("messages.illegal-item-placement.subtitle", "&cYou cannot place that block!"));
        this.illegalItemInteractionTitle = this.translateColorCodes(config.getString("messages.illegal-item-interaction.title", "&cIllegal Item!"));
        this.illegalItemInteractionSubtitle = this.translateColorCodes(config.getString("messages.illegal-item-interaction.subtitle", "&cYou tried to interact with an illegal item: %item%"));
        this.illegalItemMovementSubtitle = this.translateColorCodes(config.getString("messages.illegal-item-movement.subtitle", "&cContainer tried to move an illegal item: %item%"));
        this.illegalItemRemovalTitle = this.translateColorCodes(config.getString("messages.illegal-item-removal.title", "&cIllegal Items Removed!"));
        this.illegalItemRemovalSubtitle = this.translateColorCodes(config.getString("messages.illegal-item-removal.subtitle", "&cIllegal items were removed from your inventory."));
        this.adminAlertMessage = this.translateColorCodes(config.getString("messages.admin-alert", "&c%player% tried to interact with an illegal item: %item%"));
    }

    private String translateColorCodes(String message) {
        return message.replace("&", "\u00a7");
    }

    private void loadIllegalItems(List<String> itemNames) {
        for (String itemName : itemNames) {
            try {
                Material material = Material.valueOf((String)itemName.toUpperCase());
                this.illegalItems.add(material);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid item name in config: " + itemName);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player;
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player && this.addingIllegalItems.contains((player = (Player)humanEntity).getUniqueId())) {
            return;
        }
        this.handleItemInteraction(event.getCurrentItem(), (Player)event.getWhoClicked());
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        this.handleItemMovement(event.getItem(), event.getSource(), event.getDestination());
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (event.getView().getTitle().equals("OaExploits Settings") || event.getView().getTitle().equals("Illegal Items")) {
            return;
        }
        this.handleInventoryOpen(event.getInventory(), (Player)event.getPlayer());
    }

    @EventHandler
    public void onInventoryPickupItem(InventoryPickupItemEvent event) {
        this.handleItemInteraction(event.getItem().getItemStack(), "Container");
    }

    @EventHandler
    public void onEntityPickupItem(EntityPickupItemEvent event) {
        this.handleItemInteraction(event.getItem().getItemStack(), (Entity)event.getEntity());
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.onlinePlayers.add(playerId);
        this.checkPlayerInventory(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.onlinePlayers.remove(event.getPlayer().getUniqueId());
        this.addingIllegalItems.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.handlePlayerInteract(event);
    }

    @EventHandler
    public void onPlayerItemHeld(PlayerItemHeldEvent event) {
        this.handleItemInteraction(event.getPlayer().getInventory().getItem(event.getNewSlot()), event.getPlayer());
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        this.handleItemInteraction(event.getItemDrop().getItemStack(), event.getPlayer());
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        this.handleBlockPlace(event);
    }

    @EventHandler
    public void handleEntityPickup(EntityPickupItemEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack item = event.getItem().getItemStack();
        if (this.shouldRemoveItem(item)) {
            int removedCount = item.getAmount();
            Material itemType = item.getType();
            String itemTypeString = itemType.toString();
            this.removeItem(item);
            this.alertAdminsIfPlayer((Entity)entity, itemTypeString);
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from entity pickup by " + entity.getName());
        }
    }

    private void handleItemInteraction(ItemStack item, Player player) {
        if (item != null && this.shouldRemoveItem(item)) {
            int removedCount = item.getAmount();
            Material itemType = item.getType();
            String itemTypeString = itemType.toString();
            this.removeItem(item);
            this.notifyPlayerAndAdmins(player, this.illegalItemInteractionTitle, this.illegalItemInteractionSubtitle.replace("%item%", itemTypeString), itemTypeString);
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from player " + player.getName());
        }
    }

    private void handleItemInteraction(ItemStack item, Entity entity) {
        if (entity instanceof Player) {
            this.handleItemInteraction(item, (Player)entity);
        } else {
            String entityName = entity.getName();
            if (item != null && this.shouldRemoveItem(item)) {
                int removedCount = item.getAmount();
                Material itemType = item.getType();
                String itemTypeString = itemType.toString();
                this.removeItem(item);
                this.alertAdminsIfPlayer(entity, itemTypeString);
                this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from entity " + entityName);
            }
        }
    }

    private void handleItemInteraction(ItemStack item, String entityName) {
        if (item != null && this.shouldRemoveItem(item)) {
            int removedCount = item.getAmount();
            Material itemType = item.getType();
            String itemTypeString = itemType.toString();
            this.removeItem(item);
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from " + entityName);
        }
    }

    private void handleItemMovement(ItemStack item, Inventory source, Inventory destination) {
        if (item != null && this.shouldRemoveItem(item)) {
            int removedCount = item.getAmount();
            Material itemType = item.getType();
            String itemTypeString = itemType.toString();
            this.removeItem(item);
            this.alertAdmins(this.illegalItemMovementSubtitle.replace("%item%", itemTypeString));
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items during item movement");
        }
        this.removeIllegalItems(source, this.inventoryScanDepth);
        this.removeIllegalItems(destination, this.inventoryScanDepth);
    }

    private void handleInventoryOpen(Inventory inventory, Player player) {
        int removedCount = this.removeIllegalItems(inventory, this.inventoryScanDepth);
        if (removedCount > 0) {
            this.notifyPlayerAndAdmins(player, this.illegalItemRemovalTitle, this.illegalItemRemovalSubtitle, null);
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from inventory of player " + player.getName());
        }
    }

    private void handlePlayerInteract(PlayerInteractEvent event) {
        Action action = event.getAction();
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        switch (action) {
            case RIGHT_CLICK_BLOCK: 
            case RIGHT_CLICK_AIR: 
            case LEFT_CLICK_BLOCK: 
            case LEFT_CLICK_AIR: {
                if (!player.isSneaking() || !this.isShulkerBox(item)) break;
                this.handleShulkerBoxContents(item);
                break;
            }
        }
    }

    private void handleShulkerBoxContents(ItemStack item) {
        ShulkerBox shulker;
        int removedCount;
        BlockState blockState;
        if (!this.removeIllegalItemsEnabled) {
            return;
        }
        BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
        if (meta != null && (blockState = meta.getBlockState()) instanceof ShulkerBox && (removedCount = this.removeIllegalItems((shulker = (ShulkerBox)blockState).getInventory(), this.inventoryScanDepth - 1)) > 0) {
            meta.setBlockState((BlockState)shulker);
            item.setItemMeta((ItemMeta)meta);
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from a Shulker Box.");
        }
    }

    private void handleBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItemInHand();
        Material blockType = event.getBlock().getType();
        if (this.shouldRemoveItem(item) || this.isIllegalBlock(blockType)) {
            event.setCancelled(true);
            int removedCount = item.getAmount();
            Material itemType = item.getType();
            String itemTypeString = itemType.toString();
            this.removeItem(item);
            this.notifyPlayerAndAdmins(player, this.illegalItemPlacementTitle, this.illegalItemPlacementSubtitle.replace("%item%", blockType.toString()), itemTypeString);
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from player " + player.getName());
        } else if (this.isShulkerBox(item) && this.cleanShulkersOnPlaceEnabled) {
            this.handleShulkerBoxContents(item);
        }
    }

    private boolean isIllegalBlock(Material blockType) {
        return this.illegalItems.contains(blockType);
    }

    private void checkPlayerInventory(Player player) {
        int removedCount = this.removeIllegalItems((Inventory)player.getInventory(), this.inventoryScanDepth);
        if (removedCount > 0) {
            this.notifyPlayerAndAdmins(player, this.illegalItemRemovalTitle, this.illegalItemRemovalSubtitle, null);
            this.plugin.getLogger().info("\u001b[31mRemoved " + removedCount + " illegal items from player " + player.getName());
        }
    }

    private int removeIllegalItems(Inventory inventory, int depth) {
        if (depth < 1) {
            return 0;
        }
        int removedCount = 0;
        for (ItemStack item : inventory.getContents()) {
            if (item == null) continue;
            if (this.shouldRemoveItem(item)) {
                removedCount += item.getAmount();
                this.removeItem(item);
                continue;
            }
            if (!this.isShulkerBox(item) || depth <= 1) continue;
            removedCount += this.removeShulkerBoxContents(item, depth);
        }
        return removedCount;
    }

    private int removeShulkerBoxContents(ItemStack item, int depth) {
        ShulkerBox shulker;
        BlockState blockState;
        BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
        int removedCount = 0;
        if (meta != null && (blockState = meta.getBlockState()) instanceof ShulkerBox && (removedCount = this.removeIllegalItems((shulker = (ShulkerBox)blockState).getInventory(), depth - 1)) > 0) {
            meta.setBlockState((BlockState)shulker);
            item.setItemMeta((ItemMeta)meta);
        }
        return removedCount;
    }

    private void removeItem(ItemStack item) {
        item.setAmount(0);
    }

    private boolean isIllegalItem(ItemStack item) {
        return item != null && this.illegalItems.contains(item.getType());
    }

    private boolean shouldRemoveItem(ItemStack item) {
        return this.removeIllegalItemsEnabled && this.isIllegalItem(item);
    }

    private void alertAdmins(String message) {
        long currentTime = System.currentTimeMillis() / 1000L;
        if (this.adminAlertsEnabled && currentTime - this.lastAdminAlertTime >= (long)this.adminAlertCooldown) {
            this.lastAdminAlertTime = currentTime;
            Bukkit.getOnlinePlayers().stream().filter(player -> player.hasPermission("oaexploits.alerts")).forEach(player -> player.sendMessage(message));
        }
    }

    private void alertAdminsIfPlayer(Entity entity, String itemType) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            String message = this.adminAlertMessage.replace("%player%", player.getName()).replace("%item%", itemType);
            this.alertAdmins(message);
        }
    }

    private void notifyPlayerAndAdmins(Player player, String title, String subtitle, String itemType) {
        if (player != null && this.notifyPlayerOnIllegalPlacementEnabled) {
            String subtitleMessage = subtitle;
            if (itemType != null) {
                subtitleMessage = subtitle.replace("%item%", itemType);
            }
            this.sendTitleToPlayer(player, title, subtitleMessage);
            String adminMessage = this.adminAlertMessage.replace("%player%", player.getName()).replace("%item%", itemType != null ? itemType : "");
            this.alertAdmins(adminMessage);
        }
    }

    private void sendTitleToPlayer(Player player, String title, String subtitle) {
        TextComponent titleComponent = Component.text((String)title);
        TextComponent subtitleComponent = Component.text((String)subtitle);
        Title playerTitle = Title.title((Component)titleComponent, (Component)subtitleComponent);
        player.showTitle(playerTitle);
    }

    public Set<Material> getIllegalItems() {
        return this.illegalItems;
    }

    public int getInventoryScanDepth() {
        return this.inventoryScanDepth;
    }

    public void reloadConfigValues() {
        this.plugin.reloadConfig();
        this.loadConfigValues();
        this.plugin.getLogger().info("AntiIllegalItems configuration reloaded.");
    }

    private boolean isShulkerBox(ItemStack item) {
        return item != null && item.getType().toString().endsWith("_SHULKER_BOX");
    }

    public void addPlayerToIllegalItemAdding(UUID playerId) {
        this.addingIllegalItems.add(playerId);
    }

    public void removePlayerFromIllegalItemAdding(UUID playerId) {
        this.addingIllegalItems.remove(playerId);
    }
}

