/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.antiexploits;

import fanlim.dev.oaexploits.Oaexploits;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class OaExploitsGUI
implements Listener {
    private static final Component GUI_TITLE = Component.text((String)"OaExploits Settings").color((TextColor)NamedTextColor.GOLD);
    private static final Component TOGGLE_ILLEGAL_ITEMS = Component.text((String)"Toggle Illegal Items Removal").color((TextColor)NamedTextColor.RED);
    private static final Component TOGGLE_ADMIN_ALERTS = Component.text((String)"Toggle Admin Alerts").color((TextColor)NamedTextColor.BLUE);
    private static final Component TOGGLE_SHULKER_CLEAN = Component.text((String)"Toggle Shulker Box Cleaning").color((TextColor)NamedTextColor.GREEN);
    private static final Component RELOAD_CONFIGURATION = Component.text((String)"Reload Configuration").color((TextColor)NamedTextColor.YELLOW);
    private static final Component BORDER_ITEM = Component.text((String)" ").color((TextColor)NamedTextColor.GRAY);
    private final Oaexploits plugin;
    private final Map<UUID, Long> lastInteractionTimes = new HashMap<UUID, Long>();

    public OaExploitsGUI(Oaexploits plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openSettingsGUI(Player player) {
        if (!player.isOp()) {
            player.sendMessage(Component.text((String)"You do not have permission to use this GUI.").color((TextColor)NamedTextColor.RED));
            return;
        }
        Inventory gui = Bukkit.createInventory(null, (int)27, (Component)GUI_TITLE);
        for (int i = 0; i < gui.getSize(); ++i) {
            if (i == 10 || i == 12 || i == 14 || i == 16) continue;
            gui.setItem(i, this.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, BORDER_ITEM, new Component[0]));
        }
        this.setSettingItems(gui);
        player.openInventory(gui);
        this.playSound(player, Sound.BLOCK_NOTE_BLOCK_PLING);
    }

    private void setSettingItems(Inventory gui) {
        gui.setItem(10, this.createSettingItem(Material.REDSTONE_TORCH, TOGGLE_ILLEGAL_ITEMS, "removal-options.remove-illegal-items", "Enable or disable automatic removal of illegal items."));
        gui.setItem(12, this.createSettingItem(Material.JUKEBOX, TOGGLE_ADMIN_ALERTS, "admin-alerts.enabled", "Enable or disable admin alerts for illegal activities."));
        gui.setItem(14, this.createSettingItem(Material.SHULKER_BOX, TOGGLE_SHULKER_CLEAN, "removal-options.clean-shulkers-on-place", "Enable or disable shulker box cleaning on placement."));
        gui.setItem(16, this.createGuiItem(Material.ENCHANTED_BOOK, RELOAD_CONFIGURATION, Component.text((String)"Reload the plugin configuration.").color((TextColor)NamedTextColor.WHITE)));
    }

    private Component getStatus(String path) {
        boolean isEnabled = this.plugin.getConfig().getBoolean(path);
        return Component.text((String)("Status: " + (isEnabled ? "Enabled" : "Disabled"))).color((TextColor)(isEnabled ? NamedTextColor.GREEN : NamedTextColor.RED));
    }

    private ItemStack createGuiItem(Material material, Component displayName, Component ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(displayName);
            ArrayList<Component> loreList = new ArrayList<Component>(Arrays.asList(lore));
            meta.lore(loreList);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createSettingItem(Material material, Component displayName, String configPath, String description) {
        return this.createGuiItem(material, displayName, Component.text((String)description).color((TextColor)NamedTextColor.WHITE), this.getStatus(configPath));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.lastInteractionTimes.containsKey(playerId) && currentTime - this.lastInteractionTimes.get(playerId) < 500L) {
            event.setCancelled(true);
            return;
        }
        this.lastInteractionTimes.put(playerId, currentTime);
        Inventory inventory = event.getClickedInventory();
        if (inventory == null || event.getCurrentItem() == null || !event.getCurrentItem().hasItemMeta()) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        FileConfiguration config = this.plugin.getConfig();
        Component displayName = clickedItem.getItemMeta().displayName();
        if (event.getView().title().equals((Object)GUI_TITLE)) {
            event.setCancelled(true);
            if (!player.isOp()) {
                player.sendMessage(Component.text((String)"You do not have permission to change these settings.").color((TextColor)NamedTextColor.RED));
                return;
            }
            if (Objects.equals(displayName, TOGGLE_ILLEGAL_ITEMS)) {
                this.handleConfigOptionClick(player, config, "removal-options.remove-illegal-items", "Illegal Items Removal");
            } else if (Objects.equals(displayName, TOGGLE_ADMIN_ALERTS)) {
                this.handleConfigOptionClick(player, config, "admin-alerts.enabled", "Admin Alerts");
            } else if (Objects.equals(displayName, TOGGLE_SHULKER_CLEAN)) {
                this.handleConfigOptionClick(player, config, "removal-options.clean-shulkers-on-place", "Shulker Box Cleaning");
            } else if (Objects.equals(displayName, RELOAD_CONFIGURATION)) {
                this.plugin.reloadConfig();
                player.sendMessage(Component.text((String)"Configuration reloaded.").color((TextColor)NamedTextColor.GREEN));
                this.plugin.getLogger().info("Configuration reloaded by " + player.getName());
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.refreshSettingsGUI(player), 1L);
        }
    }

    private void handleConfigOptionClick(Player player, FileConfiguration config, String configPath, String optionName) {
        this.toggleConfigOption(player, config, configPath, optionName);
        this.playSound(player, Sound.ENTITY_PLAYER_LEVELUP);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getView().title().equals((Object)GUI_TITLE)) {
            UUID playerId = event.getPlayer().getUniqueId();
            this.lastInteractionTimes.remove(playerId);
        }
    }

    private void refreshSettingsGUI(Player player) {
        Inventory gui = player.getOpenInventory().getTopInventory();
        this.setSettingItems(gui);
    }

    private void toggleConfigOption(Player player, FileConfiguration config, String path, String optionName) {
        boolean newValue = !config.getBoolean(path);
        config.set(path, (Object)newValue);
        this.plugin.saveConfig();
        player.sendMessage(Component.text((String)(optionName + ": " + (newValue ? "Enabled" : "Disabled"))).color((TextColor)(newValue ? NamedTextColor.GREEN : NamedTextColor.RED)));
        this.plugin.getLogger().info(optionName + " set to " + newValue + " by " + player.getName());
    }

    private void playSound(Player player, Sound sound) {
        player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
    }
}

