/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.commands;

import fanlim.dev.oaexploits.Oaexploits;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;

public class CommandBlocker
implements Listener {
    private final Oaexploits plugin;

    public CommandBlocker(Oaexploits plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage().toLowerCase().trim();
        String command = message.split(" ")[0].replaceAll("^/+", "");
        if (event.getPlayer().isOp()) {
            return;
        }
        if (this.plugin.isWhitelistEnabled() && !this.plugin.getCommandWhitelist().contains(command)) {
            event.setCancelled(true);
            this.logAttempt(event.getPlayer().getName(), command, "whitelist");
            return;
        }
        if (this.plugin.isBlacklistEnabled() && this.plugin.getCommandBlacklist().contains(command)) {
            event.setCancelled(true);
            this.logAttempt(event.getPlayer().getName(), command, "blacklist");
            return;
        }
        if (this.isPluginsCommand(command) && this.plugin.isBlacklistEnabled()) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.plugin.getPluginsCommandBlockedMessage() + "\nPlugins (0): []");
            this.logAttempt(event.getPlayer().getName(), command, "plugins command");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommandSend(PlayerCommandSendEvent event) {
        if (this.plugin.isWhitelistEnabled() && !event.getPlayer().isOp()) {
            Set whitelistedCommands = this.plugin.getCommandWhitelist().stream().map(command -> command.startsWith("/") ? command.substring(1) : command).collect(Collectors.toSet());
            event.getCommands().removeIf(command -> !whitelistedCommands.contains(command.toLowerCase()));
        }
    }

    private boolean isPluginsCommand(String command) {
        return command.matches(".*[\\W_]*plugins[\\W_]*.*");
    }

    private void logAttempt(String playerName, String command, String type) {
        if (this.plugin.isDebugEnabled()) {
            this.plugin.getLogger().info("Player " + playerName + " tried to execute blocked " + type + " command: " + command);
        }
    }
}

