/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.stats;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Statistic;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayTimeStats
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private final Logger logger;

    public PlayTimeStats(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player plr;
        if (!command.getName().equalsIgnoreCase("playtime")) {
            return false;
        }
        if (!(sender instanceof Player)) {
            this.logger.info("You are not a player");
            return false;
        }
        if (args.length > 0) {
            Player player = Bukkit.getServer().getPlayer(args[0]);
            if (player == null) {
                sender.sendMessage("This player doesn't exist");
                return false;
            }
            plr = player;
        } else {
            plr = (Player)sender;
        }
        int totalSeconds = plr.getStatistic(Statistic.PLAY_ONE_MINUTE) / 20;
        int days = totalSeconds / 86400;
        int hours = totalSeconds % 86400 / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        StringBuilder result = new StringBuilder();
        if (days > 0) {
            result.append(days).append(" days ");
        }
        if (hours > 0) {
            result.append(hours).append(" hours ");
        }
        if (minutes > 0) {
            result.append(minutes).append(" minutes ");
        }
        if (seconds > 0) {
            result.append(seconds).append(" seconds ");
        }
        plr.sendMessage(String.format("%sPlaytime is %s", "\u00a76", result.toString().trim()));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> playerNames = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                playerNames.add(player.getName());
            }
            return playerNames;
        }
        return null;
    }
}

