/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.banmanager;

import fanlim.dev.oaexploits.Oaexploits;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BanListGUI
implements Listener {
    private static final Component BAN_LIST_TITLE = Component.text("Banned Players").color(NamedTextColor.DARK_GRAY);
    private static final Component PREVIOUS_PAGE = Component.text("Previous Page").color(NamedTextColor.GOLD);
    private static final Component NEXT_PAGE = Component.text("Next Page").color(NamedTextColor.GOLD);
    private static final int GUI_SIZE = 54;
    private static final int ITEMS_PER_PAGE = 28;
    private final Oaexploits plugin;
    private final List<String> bannedPlayers;
    private int currentPage;

    public BanListGUI(Oaexploits plugin, UUID ownerUUID) {
        this.plugin = plugin;
        this.currentPage = 0;
        this.bannedPlayers = new ArrayList<String>();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openBanListGUI(Player player) {
        player.closeInventory();
        this.loadBannedPlayers();
        this.showPage(player, this.currentPage);
    }

    private void loadBannedPlayers() {
        this.bannedPlayers.clear();
        Bukkit.getBanList((BanList.Type)BanList.Type.PROFILE).getBanEntries().forEach(banEntry -> this.bannedPlayers.add(banEntry.getTarget()));
    }

    private void showPage(Player player, int page) {
        Inventory banListGui = Bukkit.createInventory((InventoryHolder)new BanListInventoryHolder(player.getUniqueId()), (int)54, (Component)BAN_LIST_TITLE);
        int startIndex = page * 28;
        int endIndex = Math.min(startIndex + 28, this.bannedPlayers.size());
        for (int i = startIndex; i < endIndex; ++i) {
            OfflinePlayer bannedPlayer = Bukkit.getOfflinePlayer((String)this.bannedPlayers.get(i));
            ItemStack playerHead = this.createPlayerHeadItem(bannedPlayer);
            banListGui.setItem(10 + (i - startIndex) % 7 + (int)Math.floor((i - startIndex) / 7) * 9, playerHead);
        }
        this.fillRemainingSlotsWithFiller(banListGui);
        this.addNavigationButtons(banListGui, startIndex, endIndex);
        player.openInventory(banListGui);
        this.playSound(player, Sound.BLOCK_NOTE_BLOCK_PLING);
    }

    private ItemStack createPlayerHeadItem(OfflinePlayer bannedPlayer) {
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)playerHead.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer(bannedPlayer);
            meta.displayName(Component.text(bannedPlayer.getName()).color(NamedTextColor.RED));
            playerHead.setItemMeta((ItemMeta)meta);
        }
        return playerHead;
    }

    private void fillRemainingSlotsWithFiller(Inventory inventory) {
        ItemStack fillerItem = this.createFillerItem();
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, fillerItem);
        }
    }

    private ItemStack createFillerItem() {
        ItemStack item = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(Component.text(" ").color(NamedTextColor.GRAY));
            item.setItemMeta(meta);
        }
        return item;
    }

    private void addNavigationButtons(Inventory inventory, int startIndex, int endIndex) {
        if (startIndex > 0) {
            inventory.setItem(45, this.createNavigationItem(Material.ARROW, PREVIOUS_PAGE));
        }
        if (endIndex < this.bannedPlayers.size()) {
            inventory.setItem(53, this.createNavigationItem(Material.ARROW, NEXT_PAGE));
        }
    }

    private ItemStack createNavigationItem(Material material, Component displayName) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(displayName);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void playSound(Player player, Sound sound) {
        player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!(event.getInventory().getHolder() instanceof BanListInventoryHolder)) {
            return;
        }
        event.setCancelled(true);
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        ItemMeta itemMeta = currentItem.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        Component displayName = itemMeta.displayName();
        if (PREVIOUS_PAGE.equals(displayName)) {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.showPage(player, this.currentPage);
            }
        } else if (NEXT_PAGE.equals(displayName) && (this.currentPage + 1) * 28 < this.bannedPlayers.size()) {
            ++this.currentPage;
            this.showPage(player, this.currentPage);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().getHolder() instanceof BanListInventoryHolder) {
            // empty if block
        }
    }

    public static class BanListInventoryHolder
    implements InventoryHolder {
        private final UUID ownerUUID;

        public BanListInventoryHolder(UUID ownerUUID) {
            this.ownerUUID = ownerUUID;
        }

        @NotNull
        public Inventory getInventory() {
            return Bukkit.createInventory((InventoryHolder)this, (int)54);
        }
    }
}

