/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.banmanager;

import fanlim.dev.oaexploits.Oaexploits;
import fanlim.dev.oaexploits.banmanager.BanListGUI;
import fanlim.dev.oaexploits.banmanager.SelectPlayerToBanGUI;
import fanlim.dev.oaexploits.banmanager.SelectPlayerToUnbanGUI;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BanManagerGUI
implements Listener {
    private static final Component MANAGE_BANS_TITLE = Component.text("Manage Bans").color(NamedTextColor.DARK_GRAY);
    private static final Component BAN_PLAYER = Component.text("Ban Player").color(NamedTextColor.RED);
    private static final Component LIST_BANNED_PLAYERS = Component.text("List Banned Players").color(NamedTextColor.YELLOW);
    private static final Component UNBAN_PLAYER = Component.text("Unban Player").color(NamedTextColor.GREEN);
    private final Oaexploits plugin;

    public BanManagerGUI(Oaexploits plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openBanManagementGUI(Player player) {
        Inventory banGui = Bukkit.createInventory((InventoryHolder)new BanInventoryHolder(player.getUniqueId()), (int)27, (Component)MANAGE_BANS_TITLE);
        banGui.setItem(11, this.createGuiItem(Material.RED_BANNER, BAN_PLAYER, Component.text("Ban a player.").color(NamedTextColor.WHITE)));
        banGui.setItem(13, this.createGuiItem(Material.BOOK, LIST_BANNED_PLAYERS, Component.text("List banned players.").color(NamedTextColor.WHITE)));
        banGui.setItem(15, this.createGuiItem(Material.GREEN_BANNER, UNBAN_PLAYER, Component.text("Unban a player.").color(NamedTextColor.WHITE)));
        this.fillRemainingSlotsWithFiller(banGui);
        player.openInventory(banGui);
        this.playSound(player, Sound.BLOCK_NOTE_BLOCK_PLING);
    }

    private ItemStack createGuiItem(Material material, Component displayName, Component ... lore) {
        ItemStack item = new ItemStack(material);
        Optional.ofNullable(item.getItemMeta()).ifPresent(meta -> {
            meta.displayName(displayName);
            meta.lore(Arrays.asList(lore));
            item.setItemMeta(meta);
        });
        return item;
    }

    private void fillRemainingSlotsWithFiller(Inventory inventory) {
        ItemStack fillerItem = this.createFillerItem();
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, fillerItem);
        }
    }

    private ItemStack createFillerItem() {
        ItemStack item = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(Component.text(" ").color(NamedTextColor.GRAY));
            item.setItemMeta(meta);
        }
        return item;
    }

    private void playSound(Player player, Sound sound) {
        player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
    }

    public void handleBanPlayerClick(Player player) {
        new SelectPlayerToBanGUI(this.plugin, player.getUniqueId()).openSelectPlayerGUI(player);
    }

    public void handleListBannedPlayersClick(Player player) {
        new BanListGUI(this.plugin, player.getUniqueId()).openBanListGUI(player);
    }

    public void handleUnbanPlayerClick(Player player) {
        new SelectPlayerToUnbanGUI(this.plugin, player.getUniqueId()).openSelectPlayerGUI(player);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!(event.getInventory().getHolder() instanceof BanInventoryHolder)) {
            return;
        }
        event.setCancelled(true);
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        ItemMeta itemMeta = currentItem.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        Component displayName = itemMeta.displayName();
        if (BAN_PLAYER.equals(displayName)) {
            this.handleBanPlayerClick(player);
        } else if (LIST_BANNED_PLAYERS.equals(displayName)) {
            this.handleListBannedPlayersClick(player);
        } else if (UNBAN_PLAYER.equals(displayName)) {
            this.handleUnbanPlayerClick(player);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
    }

    public static class BanInventoryHolder
    implements InventoryHolder {
        private final UUID ownerUUID;

        public BanInventoryHolder(UUID ownerUUID) {
            this.ownerUUID = ownerUUID;
        }

        public UUID getOwnerUUID() {
            return this.ownerUUID;
        }

        @NotNull
        public Inventory getInventory() {
            return Bukkit.createInventory((InventoryHolder)this, (int)27);
        }
    }
}

