/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.banmanager;

import com.destroystokyo.paper.profile.PlayerProfile;
import fanlim.dev.oaexploits.Oaexploits;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class SelectPlayerToBanGUI
implements Listener {
    private static final Component SELECT_PLAYER_TITLE = Component.text("Select Player to Ban").color(NamedTextColor.DARK_RED);
    private static final Component SELECT_BAN_DURATION_TITLE = Component.text("Select Ban Duration").color(NamedTextColor.DARK_RED);
    private final UUID adminUUID;
    private final Map<UUID, UUID> selectedPlayers = new HashMap<UUID, UUID>();

    public SelectPlayerToBanGUI(Oaexploits plugin, UUID adminUUID) {
        this.adminUUID = adminUUID;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openSelectPlayerGUI(Player admin) {
        Inventory selectPlayerGui = Bukkit.createInventory((InventoryHolder)new SelectPlayerInventoryHolder(admin.getUniqueId()), (int)54, (Component)SELECT_PLAYER_TITLE);
        this.populateSelectPlayerGUI(selectPlayerGui, admin);
        admin.openInventory(selectPlayerGui);
        this.playSound(admin);
    }

    private void populateSelectPlayerGUI(Inventory inventory, Player admin) {
        int index = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.getUniqueId().equals(this.adminUUID) || index >= 54) continue;
            inventory.setItem(index++, this.createPlayerHeadItem(player));
        }
        this.fillEmptySlots(inventory, this.createFillerItem());
    }

    private ItemStack createPlayerHeadItem(Player player) {
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)playerHead.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer((OfflinePlayer)player);
            meta.displayName(Component.text(player.getName()).color(NamedTextColor.AQUA));
            playerHead.setItemMeta((ItemMeta)meta);
        }
        return playerHead;
    }

    private ItemStack createFillerItem() {
        ItemStack item = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(Component.text(" ").color(NamedTextColor.GRAY));
            item.setItemMeta(meta);
        }
        return item;
    }

    private void fillEmptySlots(Inventory inventory, ItemStack fillerItem) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null) continue;
            inventory.setItem(i, fillerItem);
        }
    }

    private void playSound(Player player) {
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player admin = (Player)humanEntity;
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (inventoryHolder instanceof SelectPlayerInventoryHolder) {
            SelectPlayerInventoryHolder holder = (SelectPlayerInventoryHolder)inventoryHolder;
            this.handleSelectPlayerClick(event, admin, holder);
        } else {
            inventoryHolder = event.getInventory().getHolder();
            if (inventoryHolder instanceof SelectBanDurationInventoryHolder) {
                SelectBanDurationInventoryHolder holder = (SelectBanDurationInventoryHolder)inventoryHolder;
                this.handleSelectBanDurationClick(event, admin, holder);
            }
        }
    }

    private void handleSelectPlayerClick(InventoryClickEvent event, Player admin, SelectPlayerInventoryHolder holder) {
        if (!holder.ownerUUID().equals(admin.getUniqueId())) {
            return;
        }
        event.setCancelled(true);
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        ItemMeta itemMeta = currentItem.getItemMeta();
        if (itemMeta == null || itemMeta.displayName() == null) {
            return;
        }
        String playerName = itemMeta.displayName().toString();
        Player playerToBan = Bukkit.getPlayer((String)playerName);
        if (playerToBan != null) {
            this.selectedPlayers.put(admin.getUniqueId(), playerToBan.getUniqueId());
            this.openSelectBanDurationGUI(admin);
        } else {
            admin.sendMessage(Component.text("Player " + playerName + " not found.").color(NamedTextColor.RED));
        }
    }

    private void handleSelectBanDurationClick(InventoryClickEvent event, Player admin, SelectBanDurationInventoryHolder holder) {
        if (!holder.ownerUUID().equals(admin.getUniqueId())) {
            return;
        }
        event.setCancelled(true);
        this.handleBanDurationSelection(event, admin);
    }

    private void openSelectBanDurationGUI(Player admin) {
        Inventory banDurationGui = Bukkit.createInventory((InventoryHolder)new SelectBanDurationInventoryHolder(admin.getUniqueId()), (int)27, (Component)SELECT_BAN_DURATION_TITLE);
        this.populateBanDurationGUI(banDurationGui);
        admin.openInventory(banDurationGui);
    }

    private void populateBanDurationGUI(Inventory inventory) {
        inventory.setItem(10, this.createDurationItem("1 Minute", 60));
        inventory.setItem(11, this.createDurationItem("10 Minutes", 600));
        inventory.setItem(12, this.createDurationItem("30 Minutes", 1800));
        inventory.setItem(13, this.createDurationItem("1 Hour", 3600));
        inventory.setItem(14, this.createDurationItem("1 Day", 86400));
        inventory.setItem(15, this.createDurationItem("1 Week", 604800));
        this.fillEmptySlots(inventory, this.createFillerItem());
    }

    private ItemStack createDurationItem(String name, int duration) {
        ItemStack item = new ItemStack(Material.CLOCK);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName(Component.text(name).color(NamedTextColor.GOLD));
            item.setItemMeta(meta);
        }
        item.setAmount(duration);
        return item;
    }

    private void handleBanDurationSelection(InventoryClickEvent event, Player admin) {
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        int duration = currentItem.getAmount();
        UUID playerUUID = this.selectedPlayers.get(admin.getUniqueId());
        if (playerUUID != null) {
            Player playerToBan = Bukkit.getPlayer((UUID)playerUUID);
            if (playerToBan != null) {
                PlayerProfile profile = playerToBan.getPlayerProfile();
                BanList banList = Bukkit.getBanList((BanList.Type)BanList.Type.PROFILE);
                if (banList.getBanEntry((Object)((BanEntry)profile)) != null) {
                    admin.sendMessage(Component.text(playerToBan.getName() + " is already banned.").color(NamedTextColor.RED));
                } else {
                    Instant expiration = Instant.now().plusSeconds(duration);
                    banList.addBan((Object)((BanEntry)profile), "Banned by " + admin.getName(), expiration, admin.getName());
                    admin.sendMessage(Component.text(playerToBan.getName() + " has been banned for " + currentItem.getItemMeta().displayName().toString() + ".").color(NamedTextColor.RED));
                    playerToBan.kick((Component)Component.text("You have been banned by an administrator."));
                    admin.closeInventory();
                }
            } else {
                admin.sendMessage(Component.text("Player not found.").color(NamedTextColor.RED));
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().getHolder() instanceof SelectPlayerInventoryHolder || event.getInventory().getHolder() instanceof SelectBanDurationInventoryHolder) {
            this.selectedPlayers.remove(event.getPlayer().getUniqueId());
        }
    }

    public record SelectPlayerInventoryHolder(UUID ownerUUID) implements InventoryHolder
    {
        @NotNull
        public Inventory getInventory() {
            return Bukkit.createInventory((InventoryHolder)this, (int)54);
        }
    }

    public record SelectBanDurationInventoryHolder(UUID ownerUUID) implements InventoryHolder
    {
        @NotNull
        public Inventory getInventory() {
            return Bukkit.createInventory((InventoryHolder)this, (int)27);
        }
    }
}

