/*
 * Decompiled with CFR 0.152.
 */
package fanlim.dev.oaexploits.stats;

import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Statistic;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PlayTimeStats
implements CommandExecutor,
TabCompleter {
    private static final TextColor GOLD = NamedTextColor.GOLD;
    private static final TextColor RED = NamedTextColor.RED;
    private static final String ONLY_PLAYERS_MESSAGE = "Only players can use this command";
    private static final String PLAYER_NOT_FOUND_MESSAGE = "This player doesn't exist";
    private static final String PLAYTIME_MESSAGE_PREFIX = "Playtime is ";
    private final Logger logger;

    public PlayTimeStats(JavaPlugin plugin) {
        this.logger = plugin.getLogger();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!command.getName().equalsIgnoreCase("playtime")) {
            return false;
        }
        if (!(sender instanceof Player)) {
            this.logger.info(ONLY_PLAYERS_MESSAGE);
            sender.sendMessage(Component.text(ONLY_PLAYERS_MESSAGE).color(RED));
            return false;
        }
        Player playerSender = (Player)sender;
        Optional<Player> targetPlayer = this.getPlayerFromArgs(args);
        if (targetPlayer.isEmpty()) {
            sender.sendMessage(Component.text(PLAYER_NOT_FOUND_MESSAGE).color(RED));
            return false;
        }
        String playtimeFormatted = this.formatPlaytime(this.getPlayTimeInSeconds(targetPlayer.get()));
        playerSender.sendMessage(Component.text(PLAYTIME_MESSAGE_PREFIX + playtimeFormatted).color(GOLD));
        return true;
    }

    private Optional<Player> getPlayerFromArgs(String[] args) {
        if (args.length > 0) {
            return Optional.ofNullable(Bukkit.getPlayerExact((String)args[0]));
        }
        return Optional.empty();
    }

    private int getPlayTimeInSeconds(Player player) {
        return player.getStatistic(Statistic.PLAY_ONE_MINUTE) / 20;
    }

    private String formatPlaytime(int totalSeconds) {
        int days = totalSeconds / 86400;
        int hours = totalSeconds % 86400 / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        StringBuilder result = new StringBuilder();
        if (days > 0) {
            result.append(days).append(" days ");
        }
        if (hours > 0) {
            result.append(hours).append(" hours ");
        }
        if (minutes > 0) {
            result.append(minutes).append(" minutes ");
        }
        if (seconds > 0) {
            result.append(seconds).append(" seconds");
        }
        return result.toString().trim();
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            String partialName = args[0].toLowerCase();
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(partialName)).collect(Collectors.toList());
        }
        return List.of();
    }
}

