/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.auto_planter.forge.planter;

import com.kotori316.auto_planter.planter.PlanterBlock;
import com.kotori316.auto_planter.planter.PlanterTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;

public abstract sealed class PlanterBlockForge
extends PlanterBlock {
    PlanterBlockForge(PlanterBlock.PlanterBlockType blockType, String name) {
        super(blockType, name);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (stack.canPerformAction(ToolActions.HOE_TILL)) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof PlanterTile) {
            boolean notHasSapling;
            PlanterTile planterTile = (PlanterTile)blockEntity;
            boolean bl = notHasSapling = hit.getDirection() != Direction.UP || !PlanterTile.isPlantable(stack, true);
            if (notHasSapling) {
                if (!worldIn.isClientSide()) {
                    ((ServerPlayer)player).openMenu((MenuProvider)planterTile, pos);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Nullable
    public final BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        if (toolAction == ToolActions.HOE_TILL && state.is((Block)this) && !((Boolean)state.getValue((Property)TRIGGERED)).booleanValue()) {
            return (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.TRUE);
        }
        return super.getToolModifiedState(state, context, toolAction, simulate);
    }

    public final boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.relative(facing));
        if (((Boolean)state.getValue((Property)TRIGGERED)).booleanValue()) {
            return type == PlantType.PLAINS || type == PlantType.CROP;
        }
        return type == PlantType.PLAINS;
    }

    public final boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.getValue((Property)TRIGGERED);
    }

    public static final class Upgraded
    extends PlanterBlockForge {
        public Upgraded() {
            super(PlanterBlock.PlanterBlockType.UPGRADED, "planter_upgraded");
            BlockEvent.CropGrowEvent.Pre.BUS.addListener(this::grow);
        }

        public void grow(BlockEvent.CropGrowEvent.Pre event) {
            if (event.getLevel().getBlockState(event.getPos().below()).is((Block)this)) {
                event.setResult(Result.ALLOW);
            }
        }
    }

    public static final class Normal
    extends PlanterBlockForge {
        public Normal() {
            super(PlanterBlock.PlanterBlockType.NORMAL, "planter");
        }
    }
}

