/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.auto_planter.forge.planter;

import com.kotori316.auto_planter.AutoPlanterCommon;
import com.kotori316.auto_planter.forge.planter.PlanterContainerForge;
import com.kotori316.auto_planter.planter.PlanterBlock;
import com.kotori316.auto_planter.planter.PlanterTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract sealed class PlanterTileForge
extends PlanterTile {
    public final IItemHandlerModifiable handler = new InvWrapper((Container)this);
    private final LazyOptional<IItemHandlerModifiable> handlerLazyOptional = LazyOptional.of(() -> this.handler);

    PlanterTileForge(BlockPos pos, BlockState state, PlanterBlock.PlanterBlockType blockType) {
        super(pos, state, blockType);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        this.handlerLazyOptional.invalidate();
    }

    @Override
    public PlanterContainerForge createMenu(int id, Inventory inv, Player p) {
        return new PlanterContainerForge(id, p, this.getBlockPos(), AutoPlanterCommon.accessor.planterMenuType());
    }

    public static final class Upgraded
    extends PlanterTileForge {
        public static final String TILE_ID = "auto_planter:planter_upgraded_tile";

        public Upgraded(BlockPos pos, BlockState state) {
            super(pos, state, PlanterBlock.PlanterBlockType.UPGRADED);
        }
    }

    public static final class Normal
    extends PlanterTileForge {
        public static final String TILE_ID = "auto_planter:planter_tile";

        public Normal(BlockPos pos, BlockState state) {
            super(pos, state, PlanterBlock.PlanterBlockType.NORMAL);
        }
    }
}

