/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.auto_planter.planter;

import com.kotori316.auto_planter.AutoPlanterCommon;
import com.kotori316.auto_planter.planter.PlanterTile;
import com.mojang.serialization.MapCodec;
import java.lang.reflect.Constructor;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class PlanterBlock
extends BaseEntityBlock {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    public final BlockItem blockItem;
    final PlanterBlockType blockType;
    final String name;
    protected final MapCodec<? extends PlanterBlock> planterCodec;

    protected PlanterBlock(PlanterBlockType blockType, String name) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(0.6f, 100.0f).sound(SoundType.GRAVEL).isValidSpawn((blockState, blockGetter, blockPos, entityType) -> false).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"auto_planter", (String)name))));
        this.blockType = blockType;
        this.name = name;
        this.blockItem = new BlockItem((Block)this, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"auto_planter", (String)name))).useBlockDescriptionPrefix());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
        this.planterCodec = this.createCodec();
    }

    protected final void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TRIGGERED});
    }

    protected abstract InteractionResult useItemOn(ItemStack var1, BlockState var2, Level var3, BlockPos var4, Player var5, InteractionHand var6, BlockHitResult var7);

    public final BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.blockType.entityType.get().create(pos, state);
    }

    protected final RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected final boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected final int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos, Direction direction) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)worldIn.getBlockEntity(pos));
    }

    protected void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean isMoving) {
        super.affectNeighborsAfterRemoval(state, level, pos, isMoving);
        Containers.updateNeighboursAfterDestroy((BlockState)state, (Level)level, (BlockPos)pos);
    }

    protected final void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, @Nullable Orientation orientation, boolean isMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(state, worldIn, pos, blockIn, orientation, isMoving);
        if (!worldIn.isClientSide() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof PlanterTile) {
            PlanterTile tile = (PlanterTile)blockEntity;
            tile.plantSapling();
        }
    }

    protected MapCodec<? extends PlanterBlock> codec() {
        return this.planterCodec;
    }

    protected MapCodec<? extends PlanterBlock> createCodec() {
        return PlanterBlock.createCodec(((Object)((Object)this)).getClass());
    }

    static MapCodec<? extends PlanterBlock> createCodec(Class<? extends PlanterBlock> clazz) {
        return PlanterBlock.simpleCodec(p -> {
            try {
                Constructor constructor = clazz.getConstructor(new Class[0]);
                return (PlanterBlock)((Object)((Object)constructor.newInstance(new Object[0])));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static enum PlanterBlockType {
        NORMAL(3, () -> AutoPlanterCommon.accessor.normalType()),
        UPGRADED(4, () -> AutoPlanterCommon.accessor.upgradedType());

        public final int storageSize;
        public final int rowColumn;
        public final Supplier<BlockEntityType<? extends PlanterTile>> entityType;

        private PlanterBlockType(int rowColumn, Supplier<BlockEntityType<? extends PlanterTile>> entityType) {
            this.storageSize = rowColumn * rowColumn;
            this.rowColumn = rowColumn;
            this.entityType = entityType;
        }
    }
}

