/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.auto_planter.planter;

import com.kotori316.auto_planter.planter.PlanterBlock;
import com.kotori316.auto_planter.planter.PlanterTile;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class PlanterContainer<T extends PlanterTile>
extends AbstractContainerMenu {
    public final T tile;
    private final int size;
    public static final String GUI_ID = "auto_planter:planter_gui";

    protected PlanterContainer(int id, Player player, BlockPos pos, MenuType<?> type) {
        super(type, id);
        this.tile = PlanterContainer.cast(player.level().getBlockEntity(pos));
        PlanterBlock.PlanterBlockType blockType = ((PlanterTile)((Object)this.tile)).blockType();
        this.size = blockType.storageSize;
        PlanterContainer.checkContainerSize(this.tile, (int)this.size);
        this.tile.startOpen((ContainerUser)player);
        IntIntPair startXY = switch (blockType) {
            default -> throw new MatchException(null, null);
            case PlanterBlock.PlanterBlockType.NORMAL -> IntIntPair.of((int)62, (int)17);
            case PlanterBlock.PlanterBlockType.UPGRADED -> IntIntPair.of((int)53, (int)8);
        };
        for (int i = 0; i < blockType.rowColumn; ++i) {
            for (int j = 0; j < blockType.rowColumn; ++j) {
                this.addSlot(this.createSlot(this.tile, j + i * blockType.rowColumn, startXY.leftInt() + j * 18, startXY.rightInt() + i * 18));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)player.getInventory(), i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)player.getInventory(), l, 8 + l * 18, 142));
        }
    }

    protected abstract Slot createSlot(T var1, int var2, int var3, int var4);

    public boolean stillValid(Player playerIn) {
        return ((PlanterTile)((Object)this.tile)).stillValid(playerIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            ItemStack stack = slotStack.copy();
            if (index < this.size ? !this.moveItemStackTo(slotStack, this.size, this.size + 36, true) : !this.moveItemStackTo(slotStack, 0, this.size, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        ((PlanterTile)((Object)this.tile)).stopOpen((ContainerUser)playerIn);
    }

    private static <T extends PlanterTile> T cast(Object o) {
        return (T)((Object)((PlanterTile)((Object)Objects.requireNonNull(o))));
    }
}

