/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.auto_planter.planter;

import com.kotori316.auto_planter.planter.PlanterBlock;
import com.kotori316.auto_planter.planter.PlanterContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public abstract class PlanterTile
extends BlockEntity
implements Container,
MenuProvider {
    public final NonNullList<ItemStack> inventoryContents;
    private final PlanterBlock.PlanterBlockType blockType;

    protected PlanterTile(BlockPos pos, BlockState state, PlanterBlock.PlanterBlockType blockType) {
        super(blockType.entityType.get(), pos, state);
        this.blockType = blockType;
        this.inventoryContents = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    }

    public void plantSapling() {
        if (this.level != null && !this.level.isClientSide()) {
            BlockPos upPos = this.getBlockPos().above();
            BlockState state = this.level.getBlockState(upPos);
            if (this.level.getFluidState(upPos).isEmpty()) {
                for (ItemStack maybeSapling : this.inventoryContents) {
                    DirectionalPlaceContext context;
                    if (!PlanterTile.isPlantable(maybeSapling, (Boolean)this.getBlockState().getValue((Property)PlanterBlock.TRIGGERED)) || !state.canBeReplaced((BlockPlaceContext)(context = new DirectionalPlaceContext(this.level, upPos, Direction.DOWN, maybeSapling, Direction.UP)))) continue;
                    ((BlockItem)maybeSapling.getItem()).place((BlockPlaceContext)context);
                }
            }
        }
    }

    @NotNull
    public final PlanterBlock.PlanterBlockType blockType() {
        return this.blockType;
    }

    protected void saveAdditional(ValueOutput output) {
        ContainerHelper.saveAllItems((ValueOutput)output, this.inventoryContents);
        super.saveAdditional(output);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        ContainerHelper.loadAllItems((ValueInput)input, this.inventoryContents);
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public int getContainerSize() {
        return this.blockType().storageSize;
    }

    public boolean isEmpty() {
        return this.inventoryContents.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int index) {
        return index >= 0 && index < this.inventoryContents.size() ? (ItemStack)this.inventoryContents.get(index) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = ContainerHelper.removeItem(this.inventoryContents, (int)index, (int)count);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack itemstack = (ItemStack)this.inventoryContents.get(index);
        if (itemstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.inventoryContents.set(index, (Object)ItemStack.EMPTY);
        return itemstack;
    }

    public void setItem(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public boolean stillValid(Player player) {
        return player.distanceToSqr((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5) <= 64.0;
    }

    public void stopOpen(ContainerUser user) {
        if (this.level != null && !this.level.isClientSide()) {
            this.plantSapling();
        }
    }

    public void clearContent() {
        this.inventoryContents.clear();
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return PlanterTile.isPlantable(stack, true);
    }

    public static boolean isPlantable(ItemStack stack, boolean triggered) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            if (stack.is(ItemTags.SAPLINGS)) {
                return true;
            }
            if (triggered) {
                return ((BlockItem)item).getBlock() instanceof CropBlock;
            }
        }
        return false;
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    public abstract PlanterContainer<?> createMenu(int var1, Inventory var2, Player var3);
}

