/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.gallanttirelessaltruist.init;

import com.mafuyu404.gallanttirelessaltruist.api.PostChainAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gallanttirelessaltruist", value={Dist.CLIENT})
public class ShaderManager {
    private static final Minecraft mc = Minecraft.m_91087_();
    public static final Map<String, PostChain> CHAINS = new LinkedHashMap<String, PostChain>();

    public static List<PostPass> getShader(String name) {
        if (!CHAINS.containsKey(name)) {
            return new ArrayList<PostPass>();
        }
        PostChainAccessor postChain = (PostChainAccessor)CHAINS.get(name);
        return postChain.getPasses();
    }

    public static void loadShader(String name, String jsonPath) {
        if (!CHAINS.containsKey(name)) {
            CHAINS.put(name, ShaderManager.createPostChain(jsonPath));
        }
    }

    public static boolean isLoading(String name) {
        return CHAINS.containsKey(name);
    }

    public static void initAll() {
        CHAINS.replaceAll((name, chain) -> ShaderManager.createPostChain(chain.m_110022_()));
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            CHAINS.values().forEach(chain -> {
                chain.m_110025_(mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_());
                chain.m_110023_(event.getPartialTick());
            });
            mc.m_91385_().m_83947_(false);
        }
    }

    public static void clean(String name) {
        if (CHAINS.containsKey(name)) {
            CHAINS.get(name).close();
            CHAINS.remove(name);
        }
    }

    public static void cleanup() {
        CHAINS.values().forEach(PostChain::close);
        CHAINS.clear();
    }

    private static PostChain createPostChain(String name) {
        RenderSystem.assertOnRenderThread();
        ResourceLocation rl = new ResourceLocation("gallanttirelessaltruist", name);
        try {
            return new PostChain(mc.m_91097_(), mc.m_91098_(), mc.m_91385_(), rl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

