/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.warps;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import eu.pb4.predicate.api.MinecraftPredicate;
import eu.pb4.predicate.api.PredicateContext;
import eu.pb4.predicate.api.PredicateRegistry;
import eu.pb4.warps.WarpManager;
import eu.pb4.warps.data.Target;
import eu.pb4.warps.data.WarpData;
import eu.pb4.warps.mixins.PredicateRegistryAccessor;
import eu.pb4.warps.ui.WarpSelectGui;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2179;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_2287;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7923;

public class WarpCommands {
    private static final SuggestionProvider<class_2168> WARP_ID_SUGGESTION_WITH_PREDICATE = (context, builder) -> {
        PredicateContext ctx = PredicateContext.of((class_2168)((class_2168)context.getSource()));
        for (WarpData warp : WarpManager.get().warps()) {
            if (!warp.id().startsWith(builder.getRemainingLowerCase()) || !warp.predicate().isEmpty() && !warp.predicate().get().test(ctx).success()) continue;
            builder.suggest(warp.id(), (Message)warp.name().text());
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<class_2168> WARP_ID_SUGGESTION = (context, builder) -> {
        for (WarpData warp : WarpManager.get().warps()) {
            if (!warp.id().startsWith(builder.getRemainingLowerCase())) continue;
            builder.suggest((String)(warp.id().contains(" ") ? "\"" + warp.id() + "\"" : warp.id()), (Message)warp.name().text());
        }
        return builder.buildFuture();
    };

    public static void init(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 env) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").requires(Permissions.require((String)"pbwarps.command", (boolean)true))).executes(WarpCommands::openWarpUi)).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(WARP_ID_SUGGESTION_WITH_PREDICATE).executes(WarpCommands::warpTeleportSelf)));
        Supplier<RequiredArgumentBuilder> createPosition = () -> (RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9735((boolean)true)).executes(WarpCommands::createWarp)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(WarpCommands::createWarp)).then(class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288()).executes(WarpCommands::createWarp)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warps").requires(Permissions.require((String)"pbwarps.warps_command", (boolean)true))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"create").requires(Permissions.require((String)"pbwarps.create", (int)2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(WarpCommands::createWarp)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(WarpCommands::createWarp)).then((ArgumentBuilder)createPosition.get())).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"icon", (ArgumentType)class_2287.method_9776((class_7157)access)).executes(WarpCommands::createWarp)).then((ArgumentBuilder)createPosition.get())))).then((ArgumentBuilder)createPosition.get())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"modify").requires(Permissions.require((String)"pbwarps.modify", (int)2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(WARP_ID_SUGGESTION).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"name").requires(Permissions.require((String)"pbwarps.modify.name", (int)2))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(WarpCommands::setName)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"position").requires(Permissions.require((String)"pbwarps.modify.position", (int)2))).executes(WarpCommands::setPosition)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9735((boolean)true)).executes(WarpCommands::setPosition)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(WarpCommands::setPosition)).then(class_2170.method_9244((String)"world", (ArgumentType)class_2181.method_9288()).executes(WarpCommands::setPosition)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"icon").requires(Permissions.require((String)"pbwarps.modify.icon", (int)2))).then(class_2170.method_9244((String)"icon", (ArgumentType)class_2287.method_9776((class_7157)access)).executes(WarpCommands::setIcon)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"priority").requires(Permissions.require((String)"pbwarps.modify.priority", (int)2))).then(class_2170.method_9244((String)"priority", (ArgumentType)IntegerArgumentType.integer()).executes(WarpCommands::setPriority)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"predicate").requires(Permissions.require((String)"pbwarps.modify.predicate", (int)2))).then(class_2170.method_9247((String)"clear").executes(WarpCommands::clearPredicate))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"predicate_type", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9270(PredicateRegistryAccessor.getCODECS().keySet(), (SuggestionsBuilder)builder)).executes(WarpCommands::setPredicate)).then(class_2170.method_9244((String)"data", (ArgumentType)class_2179.method_9284()).executes(WarpCommands::setPredicate))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(Permissions.require((String)"pbwarps.remove", (int)2))).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(WARP_ID_SUGGESTION).executes(WarpCommands::removeWarp)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"teleport").requires(Permissions.require((String)"pbwarps.teleport", (int)2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(WARP_ID_SUGGESTION).executes(WarpCommands::warpTeleportSelfUnrestricted)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9306()).requires(Permissions.require((String)"pbwarps.teleport.others", (int)2))).executes(WarpCommands::warpTeleportOthers))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(Permissions.require((String)"pbwarps.info", (int)2))).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).suggests(WARP_ID_SUGGESTION).executes(WarpCommands::showInfo))));
    }

    private static int showInfo(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        WarpData warp = WarpManager.get().get(id);
        if (warp == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.invalid_warp", (Object[])new Object[]{id}).method_27692(class_124.field_1061));
            return 0;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.info.id", (Object[])new Object[]{warp.id()}));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.info.priority", (Object[])new Object[]{warp.priority()}));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.info.name", (Object[])new Object[]{warp.name().text()}));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.info.unformatted_name", (Object[])new Object[]{warp.name().input()}));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.info.icon", (Object[])new Object[]{warp.icon().method_7954()}));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.info.position", (Object[])new Object[]{warp.target().pos().toString(), warp.target().yaw().map(String::valueOf).orElse("~"), warp.target().pitch().map(String::valueOf).orElse("~"), warp.target().world().method_29177().toString()}));
        if (warp.predicate().isPresent()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.info.predicate_type", (Object[])new Object[]{warp.predicate().get().identifier().toString()}));
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.info.predicate_data", (Object[])new Object[]{class_2512.method_32270((class_2520)((class_2520)warp.predicate().get().codec().codec().encodeStart((DynamicOps)((class_2168)context.getSource()).method_30497().method_57093((DynamicOps)class_2509.field_11560), (Object)warp.predicate().get()).getOrThrow()))}));
        }
        return 1;
    }

    private static int clearPredicate(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        if (WarpManager.get().updateWarp(id, x -> x.withPredicate(null))) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.modify.predicate.clear", (Object[])new Object[]{id}));
            return 1;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.invalid_warp", (Object[])new Object[]{id}).method_27692(class_124.field_1061));
        return 0;
    }

    private static int setPredicate(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        class_2960 type = class_2232.method_9443(context, (String)"predicate_type");
        MapCodec codec = PredicateRegistry.getCodec((class_2960)type);
        if (codec == null) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.modify.predicate.invalid_predicate", (Object[])new Object[]{type.toString()}).method_27692(class_124.field_1061));
            return 0;
        }
        class_2487 data = new class_2487();
        try {
            data = class_2179.method_9285(context, (String)"data");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DataResult predicate = codec.codec().decode((DynamicOps)((class_2168)context.getSource()).method_30497().method_57093((DynamicOps)class_2509.field_11560), (Object)data);
        if (predicate.isError()) {
            class_2487 alt = new class_2487();
            alt.method_10566("value", (class_2520)data);
            DataResult maybe = codec.codec().decode((DynamicOps)((class_2168)context.getSource()).method_30497().method_57093((DynamicOps)class_2509.field_11560), (Object)alt);
            if (maybe.isSuccess()) {
                predicate = maybe;
            }
        }
        if (predicate.error().isPresent()) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.modify.predicate.invalid_predicate_data", (Object[])new Object[]{type.toString()}).method_27692(class_124.field_1061));
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)((DataResult.Error)predicate.error().get()).message()).method_27692(class_124.field_1061));
            return 0;
        }
        DataResult finalPredicate = predicate;
        if (WarpManager.get().updateWarp(id, x -> x.withPredicate((MinecraftPredicate)((Pair)finalPredicate.result().get()).getFirst()))) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.modify.predicate", (Object[])new Object[]{id, type.toString(), class_2512.method_32270((class_2520)data)}));
            return 1;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.invalid_warp", (Object[])new Object[]{id}).method_27692(class_124.field_1061));
        return 0;
    }

    private static int removeWarp(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        if (WarpManager.get().removeWarp(id)) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.remove", (Object[])new Object[]{id}));
            return 1;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.invalid_warp", (Object[])new Object[]{id}).method_27692(class_124.field_1061));
        return 0;
    }

    private static int setIcon(CommandContext<class_2168> context) throws CommandSyntaxException {
        String id = StringArgumentType.getString(context, (String)"id");
        class_1799 icon = class_2287.method_9777(context, (String)"icon").method_9781(1, false);
        if (WarpManager.get().updateWarp(id, x -> x.withIcon(icon))) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.modify.icon", (Object[])new Object[]{id, icon.method_7954()}));
            return 1;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.invalid_warp", (Object[])new Object[]{id}).method_27692(class_124.field_1061));
        return 0;
    }

    private static int setPosition(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        Target target = WarpCommands.getTarget(context);
        if (WarpManager.get().updateWarp(id, x -> x.withTarget(target))) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.modify.position", (Object[])new Object[]{id, target.pos().toString(), target.yaw().map(String::valueOf).orElse("~"), target.pitch().map(String::valueOf).orElse("~"), target.world().method_29177().toString()}));
            return 1;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.invalid_warp", (Object[])new Object[]{id}).method_27692(class_124.field_1061));
        return 0;
    }

    private static int setName(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        String name = StringArgumentType.getString(context, (String)"name");
        if (WarpManager.get().updateWarp(id, x -> x.withName(name))) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.modify.name", (Object[])new Object[]{id, Objects.requireNonNull(WarpManager.get().get(id)).name().text()}));
            return 1;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.invalid_warp", (Object[])new Object[]{id}).method_27692(class_124.field_1061));
        return 0;
    }

    private static int setPriority(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        int priority = IntegerArgumentType.getInteger(context, (String)"priority");
        if (WarpManager.get().updateWarp(id, x -> x.withPriority(priority))) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.modify.priority", (Object[])new Object[]{id, Objects.requireNonNull(WarpManager.get().get(id)).name().text()}));
            return 1;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.invalid_warp", (Object[])new Object[]{id}).method_27692(class_124.field_1061));
        return 0;
    }

    private static int createWarp(CommandContext<class_2168> context) {
        String id = StringArgumentType.getString(context, (String)"id");
        Target target = WarpCommands.getTarget(context);
        class_1799 icon = ((class_1792)((class_6880.class_6883)class_7923.field_41178.method_10240(class_5819.method_43047()).orElseThrow()).comp_349()).method_7854();
        WarpData warp = new WarpData(id, target);
        try {
            icon = class_2287.method_9777(context, (String)"icon").method_9781(1, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        warp = warp.withIcon(icon);
        try {
            warp = warp.withName(StringArgumentType.getString(context, (String)"name"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (WarpManager.get().addWarp(warp)) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.create.success", (Object[])new Object[]{id, target.pos().toString(), target.yaw().map(String::valueOf).orElse("~"), target.pitch().map(String::valueOf).orElse("~"), target.world().method_29177().toString()}));
            return 1;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.create.duplicate", (Object[])new Object[]{id}).method_27692(class_124.field_1061));
        return 0;
    }

    private static Target getTarget(CommandContext<class_2168> context) {
        class_5321 world = ((class_2168)context.getSource()).method_9225().method_27983();
        class_243 pos = ((class_2168)context.getSource()).method_9222();
        float pitch = ((class_2168)context.getSource()).method_9210().field_1343;
        float yaw = ((class_2168)context.getSource()).method_9210().field_1342;
        try {
            pos = class_2277.method_9736(context, (String)"position");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            class_241 vec = class_2270.method_9716(context, (String)"rotation").method_9709((class_2168)context.getSource());
            pitch = vec.field_1343;
            yaw = vec.field_1342;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            world = class_2181.method_9289(context, (String)"world").method_27983();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new Target((class_5321<class_1937>)world, pos, Optional.of(Float.valueOf(pitch)), Optional.of(Float.valueOf(yaw)));
    }

    private static int warpTeleportSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        String id = StringArgumentType.getString(context, (String)"id");
        WarpData warp = WarpManager.get().get(id);
        if (warp != null && warp.canUse((class_2168)context.getSource())) {
            warp.handleTeleport(((class_2168)context.getSource()).method_9229());
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.warp", (Object[])new Object[]{warp.name().text()}));
            return 1;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.invalid_warp", (Object[])new Object[]{id}).method_27692(class_124.field_1061));
        return 0;
    }

    private static int warpTeleportSelfUnrestricted(CommandContext<class_2168> context) throws CommandSyntaxException {
        String id = StringArgumentType.getString(context, (String)"id");
        WarpData warp = WarpManager.get().get(id);
        if (warp != null) {
            warp.handleTeleport(((class_2168)context.getSource()).method_9229());
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.warp", (Object[])new Object[]{warp.name().text()}));
            return 1;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.invalid_warp", (Object[])new Object[]{id}).method_27692(class_124.field_1061));
        return 0;
    }

    private static int warpTeleportOthers(CommandContext<class_2168> context) throws CommandSyntaxException {
        String id = StringArgumentType.getString(context, (String)"id");
        Collection entities = class_2186.method_9317(context, (String)"entity");
        WarpData warp = WarpManager.get().get(id);
        if (warp != null) {
            for (class_1297 entity : entities) {
                warp.handleTeleport(entity);
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.teleport.other", (Object[])new Object[]{entity.method_5477(), warp.name().text()}));
            }
            return 1;
        }
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"command.pbwarps.invalid_warp", (Object[])new Object[]{id}).method_27692(class_124.field_1061));
        return 0;
    }

    private static int openWarpUi(CommandContext<class_2168> context) throws CommandSyntaxException {
        WarpSelectGui.open(((class_2168)context.getSource()).method_9207());
        return 0;
    }
}

