/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.warps;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.warps.data.WarpData;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Function;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class WarpManager {
    private static final Codec<List<WarpData>> SAVE_CODEC = WarpData.CODEC.listOf().fieldOf("warps").codec();
    private static WarpManager manager = null;
    private final TreeMap<String, WarpData> warps = new TreeMap();
    private List<WarpData> warpArr = null;
    private final Path savePath;
    private final MinecraftServer server;

    public WarpManager(MinecraftServer server, Path path) {
        this.server = server;
        this.savePath = path;
    }

    public static WarpManager get() {
        return manager;
    }

    public static void setup(MinecraftServer server) {
        Path path = server.method_27050(class_5218.field_24188).resolve("warps.json");
        manager = new WarpManager(server, path);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                DataResult data = SAVE_CODEC.decode((DynamicOps)server.method_30611().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)JsonParser.parseString((String)Files.readString(path)));
                ((List)((Pair)data.result().get()).getFirst()).forEach(x -> WarpManager.manager.warps.put(x.id(), (WarpData)x));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void destroy() {
        manager.save();
        manager = null;
    }

    public boolean addWarp(WarpData data) {
        if (this.warps.containsKey(data.id())) {
            return false;
        }
        this.warps.put(data.id(), data);
        this.warpArr = null;
        return true;
    }

    public boolean updateWarp(WarpData data) {
        if (!this.warps.containsKey(data.id())) {
            return false;
        }
        this.warps.put(data.id(), data);
        this.warpArr = null;
        return true;
    }

    public boolean updateWarp(String id, Function<WarpData, WarpData> modifier) {
        if (!this.warps.containsKey(id)) {
            return false;
        }
        WarpData warp = modifier.apply(this.warps.get(id));
        if (!warp.id().equals(id)) {
            if (this.warps.containsKey(warp.id())) {
                return false;
            }
            this.warps.remove(id);
        }
        this.warps.put(warp.id(), warp);
        this.warpArr = null;
        return true;
    }

    public boolean removeWarp(String warp) {
        boolean removed;
        boolean bl = removed = this.warps.remove(warp) != null;
        if (removed) {
            this.warpArr = null;
        }
        return removed;
    }

    @Nullable
    public WarpData get(String id) {
        return this.warps.get(id);
    }

    public List<WarpData> warps() {
        if (this.warpArr == null) {
            this.warpArr = new ArrayList<WarpData>(this.warps.values());
            this.warpArr.sort(Comparator.comparingInt(WarpData::priority).reversed().thenComparing(WarpData::id));
        }
        return this.warpArr;
    }

    public void save() {
        DataResult data = SAVE_CODEC.encodeStart((DynamicOps)this.server.method_30611().method_57093((DynamicOps)JsonOps.INSTANCE), List.copyOf(this.warps.values()));
        if (data.isSuccess()) {
            try {
                Files.writeString(this.savePath, (CharSequence)((JsonElement)data.result().get()).toString(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

