/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.warps.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.WrappedText;
import eu.pb4.predicate.api.MinecraftPredicate;
import eu.pb4.predicate.api.PredicateContext;
import eu.pb4.predicate.api.PredicateRegistry;
import eu.pb4.warps.data.Target;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5454;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public record WarpData(String id, int priority, WrappedText name, class_1799 icon, Target target, Optional<MinecraftPredicate> predicate) {
    public static final NodeParser NAME_PARSER = NodeParser.builder().requireSafe().legacyAll().quickText().build();
    public static final Codec<WarpData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(WarpData::id), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(WarpData::priority), (App)NAME_PARSER.codec().fieldOf("name").forGetter(WarpData::name), (App)class_1799.field_49747.lenientOptionalFieldOf("icon", (Object)class_1802.field_8270.method_7854()).forGetter(WarpData::icon), (App)Target.CODEC.forGetter(WarpData::target), (App)PredicateRegistry.CODEC.lenientOptionalFieldOf("predicate").forGetter(WarpData::predicate)).apply((Applicative)instance, WarpData::new));

    public WarpData(String id, Target target) {
        this(id, 0, WrappedText.from((NodeParser)NAME_PARSER, (String)id), class_1802.field_8270.method_7854(), target, Optional.empty());
    }

    public WarpData withId(String id) {
        return new WarpData(id, this.priority, this.name, this.icon, this.target, this.predicate);
    }

    public WarpData withName(String name) {
        return new WarpData(this.id, this.priority, WrappedText.from((NodeParser)NAME_PARSER, (String)name), this.icon, this.target, this.predicate);
    }

    public WarpData withIcon(class_1799 icon) {
        return new WarpData(this.id, this.priority, this.name, icon, this.target, this.predicate);
    }

    public WarpData withTarget(Target target) {
        return new WarpData(this.id, this.priority, this.name, this.icon, target, this.predicate);
    }

    public WarpData withPredicate(@Nullable MinecraftPredicate predicate) {
        return new WarpData(this.id, this.priority, this.name, this.icon, this.target, Optional.ofNullable(predicate));
    }

    public WarpData withPriority(int priority) {
        return new WarpData(this.id, priority, this.name, this.icon, this.target, this.predicate);
    }

    public void handleTeleport(class_1297 entity) {
        class_5454 target = this.target().asTeleportTarget(Objects.requireNonNull(entity.method_73183().method_8503()), entity, this::teleportEffects);
        if (target != null) {
            if (!entity.method_5767()) {
                entity.method_73183().method_8421(entity, (byte)46);
                entity.method_73183().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_46945, class_3419.field_15248, 1.0f, 1.0f);
            }
            entity.method_5731(target);
        }
    }

    private void teleportEffects(class_1297 entity) {
        if (!entity.method_5767()) {
            entity.method_73183().method_32888((class_6880)class_5712.field_39446, entity.method_73189(), class_5712.class_7397.method_43285((class_1297)entity));
            entity.method_73183().method_8421(entity, (byte)46);
            entity.method_73183().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_46945, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public boolean canUse(class_2168 source) {
        return this.predicate.isEmpty() || this.predicate.get().test(PredicateContext.of((class_2168)source)).success();
    }
}

