/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.warps.ui;

import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.warps.ui.GuiUtils;
import eu.pb4.warps.ui.PageAware;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class PagedGui
extends SimpleGui
implements PageAware {
    public static final int PAGE_SIZE = 36;
    protected final Runnable closeCallback;
    public boolean ignoreCloseCallback;
    protected int page = 0;

    public PagedGui(class_3222 player, @Nullable Runnable closeCallback) {
        super(class_3917.field_18667, player, false);
        this.closeCallback = closeCallback;
    }

    public static void playClickSound(class_3222 player) {
        GuiUtils.playClickSound(player);
    }

    public void refreshOpen() {
        this.updateDisplay();
        this.open();
    }

    public void onClose() {
        if (this.closeCallback != null && !this.ignoreCloseCallback) {
            this.closeCallback.run();
        }
    }

    @Override
    public void nextPage() {
        this.page = Math.min(this.getPageAmount() - 1, this.page + 1);
        this.updateDisplay();
    }

    protected boolean canNextPage() {
        return this.getPageAmount() > this.page + 1;
    }

    @Override
    public void previousPage() {
        this.page = Math.max(0, this.page - 1);
        this.updateDisplay();
    }

    protected boolean canPreviousPage() {
        return this.page - 1 >= 0;
    }

    protected void updateDisplay() {
        int i;
        int offset = this.page * 36;
        for (i = 0; i < 36; ++i) {
            GuiElementInterface element = this.getElement(offset + i);
            if (element == null) {
                element = GuiUtils.EMPTY;
            }
            this.setSlot(i, element);
        }
        for (i = 0; i < 9; ++i) {
            GuiElementInterface navElement = this.getNavElement(i);
            if (navElement == null) {
                navElement = GuiUtils.EMPTY;
            }
            this.setSlot(i + 36, navElement);
        }
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public void setPage(int page) {
        this.page = class_3532.method_15340((int)page, (int)0, (int)this.getPageAmount());
    }

    @Override
    public abstract int getPageAmount();

    protected abstract GuiElementInterface getElement(int var1);

    protected GuiElementInterface getNavElement(int id) {
        return switch (id) {
            case 3 -> {
                if (this.canPreviousPage()) {
                    yield GuiUtils.previousPage(this.player, this);
                }
                yield GuiUtils.fillerStack(this.player);
            }
            case 5 -> {
                if (this.canNextPage()) {
                    yield GuiUtils.nextPage(this.player, this);
                }
                yield GuiUtils.fillerStack(this.player);
            }
            case 8 -> GuiUtils.backButton(this.player, () -> this.close(false), true);
            default -> GuiUtils.fillerStack(this.player);
        };
    }
}

