/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.warps.ui;

import eu.pb4.predicate.api.PredicateContext;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.warps.WarpManager;
import eu.pb4.warps.data.WarpData;
import eu.pb4.warps.ui.GuiUtils;
import eu.pb4.warps.ui.PagedGui;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class WarpSelectGui
extends PagedGui {
    private final List<WarpData> warps = new ArrayList<WarpData>();

    protected WarpSelectGui(class_3222 player) {
        super(player, null);
        this.setTitle(GuiUtils.formatTexturedText(player, (class_2561)class_2561.method_43470((String)"e"), (class_2561)class_2561.method_43471((String)"gui.pbwarps.warp_selector")));
        PredicateContext ctx = PredicateContext.of((class_3222)player);
        for (WarpData warp : WarpManager.get().warps()) {
            if (!warp.predicate().isEmpty() && !warp.predicate().get().test(ctx).success()) continue;
            this.warps.add(warp);
        }
        this.updateDisplay();
    }

    public static void open(class_3222 player) {
        new WarpSelectGui(player).open();
    }

    @Override
    public int getPageAmount() {
        return Math.max((this.warps.size() - 1) / 36 + 1, 1);
    }

    @Override
    protected GuiElementInterface getElement(int id) {
        if (this.warps.size() > id) {
            WarpData warp = this.warps.get(id);
            GuiElementBuilder icon = GuiElementBuilder.from((class_1799)warp.icon());
            icon.setName(warp.name().text());
            icon.setCallback((x, y, z) -> {
                WarpSelectGui.playClickSound(this.player);
                this.close();
                warp.handleTeleport((class_1297)this.player);
            });
            return icon.build();
        }
        return GuiUtils.EMPTY;
    }
}

