/*
 * Decompiled with CFR 0.152.
 */
package com.mattymatty.audio_priority.screen;

import com.google.common.collect.ImmutableList;
import com.mattymatty.audio_priority.Configs;
import com.mattymatty.audio_priority.mixins.accessors.SoundManagerAccessor;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import joptsimple.internal.Strings;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class SoundListWidget
extends class_4265<AbstractSoundEntryWidget> {
    private static final class_2561 DEFAULT = class_2561.method_43471((String)"options.gamma.default");
    private final int spacebarPositionX;
    private final int rowWidth;
    List<AbstractSoundEntryWidget> sounds = new LinkedList<AbstractSoundEntryWidget>();

    public int method_65507() {
        return this.spacebarPositionX;
    }

    public int method_25322() {
        return this.rowWidth;
    }

    public SoundListWidget(class_310 client, int width, int height, int top, int itemHeight, int rowWidth) {
        super(client, width, height, top, itemHeight);
        this.rowWidth = rowWidth;
        this.spacebarPositionX = width / 2 + rowWidth / 2 + 10;
        LinkedHashMap sound_map = new LinkedHashMap();
        ((SoundManagerAccessor)this.field_22740.method_1483()).getSounds().forEach((key, value) -> {
            List elements = sound_map.computeIfAbsent(key.method_12836(), s -> new LinkedList());
            elements.add(new SoundWidgetEntry(value.method_4886(), (class_2960)key));
        });
        sound_map.entrySet().stream().sorted(Map.Entry.comparingByKey((k1, k2) -> {
            if (k1.equals("minecraft")) {
                return -1;
            }
            if (k2.equals("minecraft")) {
                return 1;
            }
            return k1.compareTo((String)k2);
        })).forEach(entry -> {
            SoundNamespaceWidget namespaceWidget = new SoundNamespaceWidget((class_2561)class_2561.method_43470((String)((String)entry.getKey()).toUpperCase()).method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}));
            this.sounds.add(namespaceWidget);
            ((List)entry.getValue()).stream().sorted().forEach(e -> {
                this.sounds.add((AbstractSoundEntryWidget)((Object)((Object)e)));
                namespaceWidget.addSubEntry((AbstractSoundEntryWidget)((Object)((Object)e)));
            });
        });
        this.showSearch(null);
    }

    public void showSearch(String search) {
        this.method_25339();
        if (search != null) {
            search = search.toLowerCase(Locale.ROOT);
        }
        for (AbstractSoundEntryWidget soundEntry : this.sounds) {
            if (!soundEntry.shouldShow(search)) continue;
            this.method_25321((class_350.class_351)soundEntry);
        }
    }

    public static abstract class AbstractSoundEntryWidget
    extends class_4265.class_4266<AbstractSoundEntryWidget> {
        public abstract boolean shouldShow(String var1);
    }

    public class SoundNamespaceWidget
    extends AbstractSoundEntryWidget {
        private final List<AbstractSoundEntryWidget> sub_entries = new LinkedList<AbstractSoundEntryWidget>();
        final class_2561 name;

        public SoundNamespaceWidget(class_2561 text) {
            this.name = text;
        }

        public void addSubEntry(AbstractSoundEntryWidget entry) {
            this.sub_entries.add(entry);
        }

        @Override
        public boolean shouldShow(String search) {
            return this.sub_entries.stream().anyMatch(e -> e.shouldShow(search));
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            context.method_27534(((SoundListWidget)SoundListWidget.this).field_22740.field_1772, this.name, this.method_46426() + SoundListWidget.this.rowWidth / 2, this.method_46427() + 5, -1);
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of();
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 builder) {
                    builder.method_37034(class_6381.field_33788, SoundNamespaceWidget.this.name);
                }
            });
        }
    }

    public class SoundWidgetEntry
    extends AbstractSoundEntryWidget
    implements Comparable<SoundWidgetEntry> {
        private final class_2960 identifier;
        private final class_2561 ruleName;
        private final class_2561 ruleSubtitle;
        private final class_2561 name;
        private final class_2561 subtitle;
        protected final List<class_339> children = new LinkedList<class_339>();
        private final VolumeSlider volumeSlider;
        private final int sliderOffset;

        public SoundWidgetEntry(class_2561 name, class_2960 identifier) {
            this.identifier = identifier;
            class_5250 text = class_2561.method_43470((String)identifier.method_12832());
            class_5250 text2 = null;
            if (name != null) {
                text2 = class_2561.method_43470((String)"( ");
                text2.method_10852(name);
                text2.method_10852((class_2561)class_2561.method_43470((String)" )"));
            }
            this.ruleName = text;
            this.ruleSubtitle = name;
            assert (SoundListWidget.this.field_22740 != null);
            this.name = this.ruleName;
            this.subtitle = text2;
            Objects.requireNonNull(((SoundListWidget)SoundListWidget.this).field_22740.field_1772);
            int fontHeight = 9;
            this.sliderOffset = Math.max(0, fontHeight + 2 - 10);
            float value = Configs.getInstance().soundVolumes.getOrDefault(identifier.toString(), Float.valueOf(1.0f)).floatValue();
            this.volumeSlider = new VolumeSlider(SoundListWidget.this, 0, 0, 100, 20, name, value, newValue -> {
                if (newValue < 0.0) {
                    newValue = 0.0;
                }
                if (Math.abs(newValue - 1.0) < 0.01) {
                    Configs.getInstance().soundVolumes.remove(identifier.toString());
                } else {
                    Configs.getInstance().soundVolumes.put(identifier.toString(), Float.valueOf((float)newValue.doubleValue()));
                }
            });
            this.children.add((class_339)this.volumeSlider);
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        protected void drawName(class_332 context, int textOffset, int x, int y) {
            assert (SoundListWidget.this.field_22740 != null);
            LinkedList<Object> texts = new LinkedList<Object>();
            if (this.name != null) {
                texts.add(this.name);
            }
            if (this.subtitle != null) {
                texts.add(this.subtitle.method_27661().method_27692(class_124.field_1080));
            }
            int index = 0;
            int textEnd = x + textOffset;
            class_327 renderer = ((SoundListWidget)SoundListWidget.this).field_22740.field_1772;
            int offset = 2;
            if (texts.size() == 1) {
                Objects.requireNonNull(renderer);
                offset = 9 / 2 + 3;
            }
            class_327 textRenderer = class_310.method_1551().field_1772;
            for (class_2561 class_25612 : texts) {
                int textWidth = renderer.method_27525((class_5348)class_25612);
                Objects.requireNonNull(textRenderer);
                context.method_27535(textRenderer, class_25612, textEnd - textWidth, y + offset + index * (9 + 1), -1);
                ++index;
            }
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            this.drawName(context, SoundListWidget.this.rowWidth - this.volumeSlider.method_25368() - 10, this.method_46426(), this.method_46427());
            this.volumeSlider.method_46421(this.method_46426() + SoundListWidget.this.rowWidth - this.volumeSlider.method_25368() + 1);
            this.volumeSlider.method_46419(this.method_46427() + this.sliderOffset);
            this.volumeSlider.method_25394(context, mouseX, mouseY, deltaTicks);
        }

        @Override
        public boolean shouldShow(String search) {
            if (Strings.isNullOrEmpty((String)search)) {
                return true;
            }
            return this.ruleName.getString().toLowerCase(Locale.ROOT).contains(search) || this.ruleSubtitle != null && this.ruleSubtitle.getString().toLowerCase(Locale.ROOT).contains(search);
        }

        public class_2561 getRuleName() {
            return this.ruleName;
        }

        public boolean getStatus() {
            return !Configs.getInstance().soundVolumes.containsKey(this.identifier.toString());
        }

        @Override
        public int compareTo(@NotNull SoundWidgetEntry o) {
            int ret = Boolean.compare(this.getStatus(), o.getStatus());
            if (ret == 0) {
                return this.getRuleName().getString().compareTo(o.getRuleName().getString());
            }
            return ret;
        }
    }

    private class VolumeSlider
    extends class_357 {
        private final Consumer<Double> callback;

        public VolumeSlider(SoundListWidget soundListWidget, int x, int y, int width, int height, class_2561 label, double value, Consumer<Double> callback) {
            super(x, y, width, height, label, value);
            this.callback = callback;
            this.method_25346();
        }

        protected void method_25346() {
            if (this.field_22753 <= 0.0) {
                this.method_25355(class_5244.field_24333);
            } else if (Math.abs(this.field_22753 - 1.0) < 0.01) {
                this.method_25355(DEFAULT);
            } else {
                this.method_25355((class_2561)class_2561.method_43470((String)((int)(this.field_22753 * 100.0) + "%")));
            }
        }

        protected void method_25344() {
            this.callback.accept(Math.max(0.0, this.field_22753));
        }
    }
}

