/*
 * Decompiled with CFR 0.152.
 */
package com.mattymatty.audio_priority.mixins;

import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import com.mattymatty.audio_priority.Configs;
import com.mattymatty.audio_priority.client.AudioPriority;
import com.mattymatty.audio_priority.exceptions.SoundPoolException;
import com.mattymatty.audio_priority.mixins.accessors.SoundEngineAccessor;
import java.lang.ref.WeakReference;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1140;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_4225;
import net.minecraft.class_4235;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1140.class})
public abstract class SoundSystemMixin {
    @Unique
    private final Object memoryLock = new Object();
    @Unique
    private final Map<class_243, List<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>>> playedByPos = new HashMap<class_243, List<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>>>();
    @Unique
    private final Map<class_2960, List<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>>> playedByIdentifier = new HashMap<class_2960, List<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>>>();
    @Unique
    Map<Integer, Set<class_1113>> soundsPerTick = new TreeMap<Integer, Set<class_1113>>();
    @Shadow
    private int field_5550;
    @Shadow
    @Final
    private Map<class_1113, Integer> field_5566;
    @Shadow
    @Final
    private class_4225 field_18945;
    @Shadow
    @Final
    private Multimap<class_3419, class_1113> field_18951;
    @Shadow
    @Final
    private Map<class_1113, Integer> field_18952;

    @Unique
    private static int sound_comparator(class_1113 sound) {
        class_243 playerPos = null;
        class_746 client = class_310.method_1551().field_1724;
        if (client != null) {
            playerPos = client.method_73189();
        }
        int category = Configs.getInstance().categoryClasses.getOrDefault(sound.method_4774().method_14840(), class_3419.values().length);
        int tie_break = 1;
        if (playerPos != null) {
            tie_break *= (int)playerPos.method_1022(new class_243(sound.method_4784(), sound.method_4779(), sound.method_4778()));
        }
        return category * 10000 + Math.min(tie_break, 9999);
    }

    @Unique
    @NotNull
    private List<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>> getSoundsAtPosition(class_243 pos) {
        return this.playedByPos.computeIfAbsent(pos, i -> new LinkedList());
    }

    @Unique
    @NotNull
    private List<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>> getSoundsByID(class_2960 id) {
        return this.playedByIdentifier.computeIfAbsent(id, i -> new LinkedList());
    }

    @Shadow
    public abstract class_1140.class_11518 method_4854(class_1113 var1);

    @Shadow
    public abstract void method_4852(class_1113 var1, int var2);

    @Unique
    private Set<class_1113> getSoundList(int tick) {
        return this.soundsPerTick.computeIfAbsent(tick, k -> new LinkedHashSet());
    }

    @WrapOperation(method={"play(Lnet/minecraft/client/sound/SoundInstance;)Lnet/minecraft/client/sound/SoundSystem$PlayResult;"}, at={@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;join()Ljava/lang/Object;")})
    Object onAcquireSourceManager(CompletableFuture<Object> instance, Operation<Object> original, class_1113 sound) {
        Object ret = original.call(new Object[]{instance});
        if (ret == null) {
            throw new SoundPoolException();
        }
        List<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>> soundsHere = this.getSoundsAtPosition(new class_243(Math.floor(sound.method_4784()), Math.floor(sound.method_4779()), Math.floor(sound.method_4778())));
        List<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>> similarSounds = this.getSoundsByID(sound.method_4775());
        class_3545 entry = new class_3545(new WeakReference<class_1113>(sound), new WeakReference<class_4235.class_4236>((class_4235.class_4236)ret));
        soundsHere.add((class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>)entry);
        similarSounds.add((class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>)entry);
        return ret;
    }

    @ModifyArg(method={"tick()V"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;forEach(Ljava/util/function/Consumer;)V"))
    Consumer<class_1113> next_tick_play(Consumer<class_1113> action) {
        return sound -> this.method_4852((class_1113)sound, -1);
    }

    @Inject(method={"play(Lnet/minecraft/client/sound/SoundInstance;I)V"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;")})
    void schedule_play(class_1113 sound, int delay, CallbackInfo ci) {
        this.getSoundList(this.field_5550 + delay).add(sound);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.AFTER)})
    void schedule_repeating_play(CallbackInfo ci, @Local class_1113 soundInstance) {
        this.getSoundList(this.field_5550 + soundInstance.method_4780()).add(soundInstance);
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;", ordinal=1, shift=At.Shift.BEFORE)}, cancellable=true)
    void play_current_tick_sounds(CallbackInfo ci) {
        Set tickKeys = this.soundsPerTick.keySet().stream().filter(i -> i < this.field_5550).collect(Collectors.toSet());
        List<class_1113> instances = this.soundsPerTick.entrySet().stream().filter(e -> tickKeys.contains(e.getKey())).flatMap(e -> ((Set)e.getValue()).stream()).distinct().sorted(Comparator.comparingInt(SoundSystemMixin::sound_comparator)).toList();
        long total = instances.size();
        long count = 0L;
        Iterator<class_1113> iterator = instances.iterator();
        try {
            while (iterator.hasNext()) {
                class_1113 soundInstance = iterator.next();
                this.method_4854(soundInstance);
                if (soundInstance instanceof class_1117) {
                    ((class_1117)soundInstance).method_16896();
                }
                ++count;
                this.field_5566.remove(soundInstance);
            }
        }
        catch (SoundPoolException ex) {
            AudioPriority.LOGGER.warn("Sound pool full, Skipped {} sound events", (Object)(total - count));
            instances.forEach(this.field_5566::remove);
        }
        for (Integer key : tickKeys) {
            this.soundsPerTick.remove(key).clear();
        }
        ci.cancel();
    }

    @Inject(method={"stopAll"}, at={@At(value="HEAD")})
    void stopAll(CallbackInfo ci) {
        this.playedByPos.forEach((k, m) -> m.clear());
        this.playedByPos.clear();
        this.playedByIdentifier.clear();
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;remove()V", shift=At.Shift.AFTER)}, slice={@Slice(from=@At(value="INVOKE", target="Ljava/util/Map;entrySet()Ljava/util/Set;", ordinal=0), to=@At(value="INVOKE", target="Ljava/util/Map;entrySet()Ljava/util/Set;", ordinal=1))})
    void tickStoppedPlaying(CallbackInfo ci, @Local class_1113 sound) {
        this.stopped_playing(sound);
    }

    @Inject(method={"stop(Lnet/minecraft/client/sound/SoundInstance;)V"}, at={@At(value="HEAD")})
    void stop_sound(class_1113 sound, CallbackInfo ci) {
        this.stopped_playing(sound);
    }

    @Inject(cancellable=true, method={"play(Lnet/minecraft/client/sound/SoundInstance;)Lnet/minecraft/client/sound/SoundSystem$PlayResult;"}, at={@At(value="INVOKE_ASSIGN", ordinal=0, target="Lnet/minecraft/client/sound/Sound;isStreamed()Z")})
    void should_play_sound(class_1113 sound, CallbackInfoReturnable<class_1140.class_11518> cir, @Local(ordinal=2) LocalFloatRef volume) {
        class_4225.class_4276 sourceSet;
        if (sound == null) {
            return;
        }
        if (sound.method_4776() == null) {
            return;
        }
        class_4225.class_4276 streamingSources = ((SoundEngineAccessor)this.field_18945).getStreamingSources();
        class_4225.class_4276 staticSources = ((SoundEngineAccessor)this.field_18945).getStaticSources();
        float volumeMultiplier = Configs.getInstance().soundVolumes.getOrDefault(sound.method_4775().toString(), Float.valueOf(1.0f)).floatValue();
        class_4225.class_4276 class_42762 = sourceSet = sound.method_4776().method_4769() ? staticSources : streamingSources;
        if (volumeMultiplier <= 0.0f || !this.should_play(sound, sourceSet)) {
            cir.setReturnValue((Object)class_1140.class_11518.field_60955);
            cir.cancel();
        } else {
            volume.set(volume.get() * volumeMultiplier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private boolean should_play(class_1113 sound, class_4225.class_4276 dest) {
        float percentage;
        int max_count;
        int sound_count;
        boolean ret;
        if (sound == null) {
            return false;
        }
        if (!Configs.getInstance().instantCategories.contains(sound.method_4774().method_14840())) {
            Object object = this.memoryLock;
            synchronized (object) {
                List<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>> soundsHere = this.getSoundsAtPosition(new class_243(Math.floor(sound.method_4784()), Math.floor(sound.method_4779()), Math.floor(sound.method_4778())));
                List<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>> similarSounds = this.getSoundsByID(sound.method_4775());
                Iterator<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>> iterator = soundsHere.iterator();
                int positionCount = 0;
                while (iterator.hasNext()) {
                    class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>> reference = iterator.next();
                    class_1113 instance = (class_1113)((WeakReference)reference.method_15442()).get();
                    class_4235.class_4236 manager = (class_4235.class_4236)((WeakReference)reference.method_15441()).get();
                    if (instance == null || manager == null || manager.method_19732()) {
                        iterator.remove();
                        continue;
                    }
                    if (!instance.method_4775().equals((Object)sound.method_4775())) continue;
                    ++positionCount;
                }
                iterator = similarSounds.iterator();
                int identifierCount = 0;
                while (iterator.hasNext()) {
                    class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>> reference = iterator.next();
                    class_1113 instance = (class_1113)((WeakReference)reference.method_15442()).get();
                    class_4235.class_4236 manager = (class_4235.class_4236)((WeakReference)reference.method_15441()).get();
                    if (instance == null || manager == null || manager.method_19732()) {
                        iterator.remove();
                        continue;
                    }
                    ++identifierCount;
                }
                if (positionCount > Configs.getInstance().maxDuplicatedSoundsByPos) {
                    AudioPriority.LOGGER.debug("Duplicated Sound {} at {} {} {}, Skipped", (Object)sound.method_4775(), (Object)sound.method_4784(), (Object)sound.method_4779(), (Object)sound.method_4778());
                    return false;
                }
                if (identifierCount > Configs.getInstance().maxDuplicatedSoundsById) {
                    AudioPriority.LOGGER.debug("Duplicated Sound Id {}, Skipped", (Object)sound.method_4775());
                    return false;
                }
            }
        }
        boolean bl = ret = (float)(sound_count = dest.method_20299()) < (float)(max_count = dest.method_20298()) * (percentage = Configs.getInstance().maxPercentPerCategory.getOrDefault(sound.method_4774().method_14840(), Float.valueOf(0.1f)).floatValue());
        if (!ret) {
            AudioPriority.LOGGER.debug("Sound pool level {}% too high for {} sounds, Skipped", (Object)Float.valueOf((float)sound_count / (float)max_count * 100.0f), (Object)sound.method_4774().method_14840());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void stopped_playing(class_1113 sound) {
        if (sound != null) {
            class_243 pos = new class_243(Math.floor(sound.method_4784()), Math.floor(sound.method_4779()), Math.floor(sound.method_4778()));
            class_2960 identifier = sound.method_4775();
            Object object = this.memoryLock;
            synchronized (object) {
                WeakReference manager;
                WeakReference instance;
                class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>> entry;
                List<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>> soundsHere = this.getSoundsAtPosition(pos);
                List<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>> similarSounds = this.getSoundsByID(sound.method_4775());
                Iterator<class_3545<WeakReference<class_1113>, WeakReference<class_4235.class_4236>>> iterator = soundsHere.iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    instance = (WeakReference)entry.method_15442();
                    manager = (WeakReference)entry.method_15441();
                    if (!instance.refersTo(null) && !manager.refersTo(null) && !((class_4235.class_4236)manager.get()).method_19732()) continue;
                    iterator.remove();
                }
                iterator = similarSounds.iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    instance = (WeakReference)entry.method_15442();
                    manager = (WeakReference)entry.method_15441();
                    if (!instance.refersTo(null) && !manager.refersTo(null) && !((class_4235.class_4236)manager.get()).method_19732()) continue;
                    iterator.remove();
                }
                if (soundsHere.isEmpty()) {
                    this.playedByPos.remove(pos);
                }
                if (similarSounds.isEmpty()) {
                    this.playedByIdentifier.remove(identifier);
                }
            }
        }
    }
}

