/*
 * Decompiled with CFR 0.152.
 */
package niv.burning.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import niv.burning.api.BurningContext;
import org.jetbrains.annotations.Nullable;

public final class Burning {
    private static final Map<class_1792, Burning> ZEROS = HashMap.newHashMap(50);
    private static final Map<class_1792, Burning> ONES = HashMap.newHashMap(50);
    public static final Burning LAVA_BUCKET = new Burning(0.0, class_1802.field_8187).one().zero();
    public static final Burning BLAZE_ROD = new Burning(0.0, class_1802.field_8894).one().zero();
    public static final Burning COAL = new Burning(0.0, class_1802.field_8713).one().zero();
    public static final Burning MIN_VALUE = LAVA_BUCKET.zero();
    public static final Burning MAX_VALUE = LAVA_BUCKET.one();
    private final double percent;
    private final class_1792 fuel;

    private Burning(double percent, class_1792 fuel) {
        this.percent = percent;
        this.fuel = fuel;
    }

    public double getPercent() {
        return this.percent;
    }

    public class_1792 getFuel() {
        return this.fuel;
    }

    public int getBurnDuration(BurningContext context) {
        return context.burnDuration(this.fuel);
    }

    public Double getValue(BurningContext context) {
        return (double)context.burnDuration(this.fuel) * this.percent;
    }

    public Double getReverseValue(BurningContext context) {
        return (double)context.burnDuration(this.fuel) * (1.0 - this.percent);
    }

    public Burning zero() {
        return ZEROS.computeIfAbsent(this.fuel, item -> new Burning(0.0, (class_1792)item));
    }

    public Burning one() {
        return ONES.computeIfAbsent(this.fuel, item -> new Burning(1.0, (class_1792)item));
    }

    public Burning withValue(int value, BurningContext context) {
        double d;
        if (value <= 0) {
            return this.zero();
        }
        double max = this.getBurnDuration(context);
        if ((double)value <= d) {
            return new Burning((double)value / max, this.fuel);
        }
        return this.one();
    }

    public Burning withFuel(class_1792 fuel, BurningContext context) {
        double d;
        if (this.percent == 0.0) {
            return Burning.ofOptional(fuel, context).orElse(this);
        }
        double max = context.burnDuration(fuel);
        if (d > 0.0) {
            double d2;
            double x = this.getValue(context) / max;
            if (d2 <= 1.0) {
                return new Burning(x, fuel);
            }
        }
        return Burning.ofOptional(fuel, context).orElse(this).one();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.percent);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.fuel == null ? 0 : this.fuel.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Burning) {
            Burning that = (Burning)object;
            return this.percent == that.percent && Objects.equals(this.fuel, that.fuel);
        }
        return false;
    }

    public String toString() {
        return "Burning [" + this.percent + " of " + String.valueOf(this.fuel) + "]";
    }

    @Nullable
    public static final Burning of(class_1792 fuel, BurningContext context) {
        return context.isFuel(fuel) ? ZEROS.computeIfAbsent(fuel, item -> new Burning(0.0, (class_1792)item)) : null;
    }

    public static final Optional<Burning> ofOptional(class_1792 fuel, BurningContext context) {
        return Optional.ofNullable(Burning.of(fuel, context));
    }

    public static final Burning ofZero(class_1792 fuel) {
        return ZEROS.computeIfAbsent(fuel, item -> new Burning(0.0, (class_1792)item));
    }

    public static final Burning add(Burning a, Burning b, BurningContext context) {
        double value = a.getValue(context) + b.getValue(context);
        return a.getBurnDuration(context) >= b.getBurnDuration(context) ? Burning.combine(a, b, value, context) : Burning.combine(b, a, value, context);
    }

    public static final Burning subtract(Burning a, Burning b, BurningContext context) {
        double value = Math.max(0.0, a.getValue(context) - b.getValue(context));
        return a.getBurnDuration(context) >= b.getBurnDuration(context) ? Burning.combine(a, b, value, context) : Burning.combine(b, a, value, context);
    }

    public static final int compareValue(Burning a, Burning b, BurningContext context) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return Double.compare(a.getValue(context), b.getValue(context));
    }

    public static final Burning maxValue(Burning a, Burning b, BurningContext context) {
        return Burning.compareValue(a, b, context) >= 0 ? a : b;
    }

    public static final Burning minValue(Burning a, Burning b, BurningContext context) {
        return Burning.compareValue(a, b, context) <= 0 ? a : b;
    }

    private static final Burning combine(Burning high, Burning low, double value, BurningContext context) {
        if (value <= (double)low.getBurnDuration(context)) {
            return low.withValue((int)value, context);
        }
        if (value <= (double)high.getBurnDuration(context)) {
            return high.withValue((int)value, context);
        }
        return MIN_VALUE.withValue((int)value, context);
    }
}

