/*
 * Decompiled with CFR 0.152.
 */
package niv.burning.api.base;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import niv.burning.api.Burning;
import niv.burning.api.BurningContext;
import niv.burning.api.BurningStorage;
import org.jetbrains.annotations.Nullable;

public class DelegatingBurningStorage
implements BurningStorage {
    protected final Supplier<? extends BurningStorage> backingStorage;
    protected final BooleanSupplier validPredicate;

    public DelegatingBurningStorage(BurningStorage backingStorage, @Nullable BooleanSupplier validPredicate) {
        this(() -> backingStorage, validPredicate);
        Objects.requireNonNull(backingStorage);
    }

    public DelegatingBurningStorage(Supplier<? extends BurningStorage> backingStorageSupplier, @Nullable BooleanSupplier validPredicate) {
        this.backingStorage = Objects.requireNonNull(backingStorageSupplier);
        this.validPredicate = validPredicate == null ? () -> true : validPredicate;
    }

    @Override
    public boolean supportsInsertion() {
        return this.validPredicate.getAsBoolean() && this.backingStorage.get().supportsInsertion();
    }

    @Override
    public Burning insert(Burning burning, BurningContext context, TransactionContext transaction) {
        return this.validPredicate.getAsBoolean() ? this.backingStorage.get().insert(burning, context, transaction) : burning.zero();
    }

    @Override
    public boolean supportsExtraction() {
        return this.validPredicate.getAsBoolean() && this.backingStorage.get().supportsExtraction();
    }

    @Override
    public Burning extract(Burning burning, BurningContext context, TransactionContext transaction) {
        return this.validPredicate.getAsBoolean() ? this.backingStorage.get().extract(burning, context, transaction) : burning.zero();
    }

    @Override
    public Burning getBurning(BurningContext context) {
        return this.validPredicate.getAsBoolean() ? this.backingStorage.get().getBurning(context) : Burning.MIN_VALUE;
    }

    @Override
    public boolean isBurning() {
        return this.validPredicate.getAsBoolean() && this.backingStorage.get().isBurning();
    }
}

