/*
 * Decompiled with CFR 0.152.
 */
package niv.burning.api.base;

import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import niv.burning.api.Burning;
import niv.burning.api.BurningContext;
import niv.burning.api.BurningStorage;
import niv.burning.api.base.BurningStorageBlockEntity;
import niv.burning.api.base.SimpleBurningStorage;

public class FurnaceBurningStorage
extends SnapshotParticipant<SimpleBurningStorage.Snapshot>
implements BurningStorage {
    private final class_2609 target;

    public FurnaceBurningStorage(class_2609 target) {
        this.target = target;
    }

    private Burning getZero() {
        class_1792 fuel = this.target.getInternalBurningFuel();
        return fuel == null ? Burning.MIN_VALUE : Burning.ofZero(fuel);
    }

    private void setZero(Burning zero) {
        this.target.setInternalBurningFuel(zero.getFuel());
    }

    @Override
    public Burning insert(Burning burning, BurningContext context, TransactionContext transaction) {
        context = new Context(this, this.target);
        int fuelTime = burning.getBurnDuration(context);
        int value = Math.min(Math.max(this.target.field_11980, fuelTime) - this.target.field_11981, burning.getValue(context).intValue());
        this.updateSnapshots(transaction);
        this.target.field_11981 += value;
        if (this.target.field_11980 > fuelTime && this.target.field_11981 <= fuelTime || this.target.field_11981 > this.target.field_11980) {
            this.target.field_11980 = fuelTime;
            this.setZero(burning);
        }
        return burning.withValue(value, context);
    }

    @Override
    public boolean supportsExtraction() {
        return false;
    }

    @Override
    public Burning extract(Burning burning, BurningContext context, TransactionContext transaction) {
        return burning.zero();
    }

    @Override
    public Burning getBurning(BurningContext context) {
        return this.getZero().withValue(this.target.field_11981, new Context(this, this.target));
    }

    @Override
    public boolean isBurning() {
        return this.target.field_11981 > 0;
    }

    protected SimpleBurningStorage.Snapshot createSnapshot() {
        return new SimpleBurningStorage.Snapshot(this.target.field_11981, this.target.field_11980, this.getZero());
    }

    protected void readSnapshot(SimpleBurningStorage.Snapshot snapshot) {
        this.target.field_11981 = snapshot.currentBurning();
        this.target.field_11980 = snapshot.maxBurning();
        this.setZero(snapshot.zero());
    }

    protected void onFinalCommit() {
        BurningStorageBlockEntity.tryUpdateLitProperty((class_2586)this.target, this);
        this.target.method_5431();
    }

    protected final class Context
    implements BurningContext {
        private final class_2609 target;

        public Context(FurnaceBurningStorage this$0, class_2609 target) {
            this.target = target;
        }

        @Override
        public boolean isFuel(class_1792 item) {
            return class_2609.method_11195((class_1799)new class_1799((class_1935)item));
        }

        @Override
        public boolean isFuel(class_1799 itemStack) {
            return class_2609.method_11195((class_1799)itemStack);
        }

        @Override
        public int burnDuration(class_1792 item) {
            return this.target.method_11200(new class_1799((class_1935)item));
        }

        @Override
        public int burnDuration(class_1799 itemStack) {
            return this.target.method_11200(itemStack);
        }
    }
}

