/*
 * Decompiled with CFR 0.152.
 */
package niv.burning.api.base;

import java.util.function.IntUnaryOperator;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import niv.burning.api.Burning;
import niv.burning.api.BurningContext;
import niv.burning.api.BurningStorage;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleBurningStorage
extends SnapshotParticipant<Snapshot>
implements BurningStorage {
    protected final IntUnaryOperator operator;
    protected int currentBurning;
    protected int maxBurning;
    protected Burning zero;

    public SimpleBurningStorage() {
        this(null);
    }

    public SimpleBurningStorage(@Nullable IntUnaryOperator operator) {
        this.operator = operator == null ? IntUnaryOperator.identity() : operator;
        this.currentBurning = 0;
        this.maxBurning = 0;
        this.zero = Burning.MIN_VALUE;
    }

    public int getCurrentBurning() {
        return this.currentBurning;
    }

    public void setCurrentBurning(int value) {
        this.currentBurning = Math.clamp((long)value, 0, this.maxBurning);
    }

    public int getMaxBurning() {
        return this.maxBurning;
    }

    public void setMaxBurning(int value) {
        this.maxBurning = Math.max(0, value);
        if (this.currentBurning > this.maxBurning) {
            this.currentBurning = this.maxBurning;
        }
    }

    public void load(class_2487 compoundTag) {
        class_2487 snapshotTag = compoundTag.method_10562("BurningSnapshot");
        this.readSnapshot(new Snapshot(snapshotTag.method_10550("CurrentBurning"), snapshotTag.method_10550("MaxBurning"), Burning.ofZero((class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)snapshotTag.method_10558("Zero"))))));
    }

    public void save(class_2487 compoundTag) {
        class_2487 snapshotTag = new class_2487();
        Snapshot snapshot = this.createSnapshot();
        snapshotTag.method_10569("CurrentBurning", snapshot.currentBurning());
        snapshotTag.method_10569("MaxBurning", snapshot.maxBurning());
        snapshotTag.method_10582("Zero", class_7923.field_41178.method_10221((Object)snapshot.zero().getFuel()).toString());
        compoundTag.method_10566("BurningSnapshot", (class_2520)snapshotTag);
    }

    public Snapshot createSnapshot() {
        return new Snapshot(this.currentBurning, this.maxBurning, this.zero);
    }

    public void readSnapshot(Snapshot snapshot) {
        this.currentBurning = snapshot.currentBurning;
        this.maxBurning = snapshot.maxBurning;
        this.zero = snapshot.zero;
    }

    protected abstract void onFinalCommit();

    @Override
    public Burning insert(Burning burning, BurningContext context, TransactionContext transaction) {
        context = new Context(context, this.operator);
        int fuelTime = burning.getBurnDuration(context);
        int value = Math.min(Math.max(this.maxBurning, fuelTime) - this.currentBurning, burning.getValue(context).intValue());
        this.updateSnapshots(transaction);
        this.currentBurning += value;
        if (this.maxBurning > fuelTime && this.currentBurning <= fuelTime || this.currentBurning > this.maxBurning) {
            this.maxBurning = fuelTime;
            this.zero = burning.zero();
        }
        return burning.withValue(value, context);
    }

    @Override
    public Burning extract(Burning burning, BurningContext context, TransactionContext transaction) {
        context = new Context(context, this.operator);
        int fuelTime = burning.getBurnDuration(context);
        int value = Math.min(this.currentBurning, burning.getValue(context).intValue());
        this.updateSnapshots(transaction);
        this.currentBurning -= value;
        if (this.maxBurning > fuelTime && this.currentBurning <= fuelTime) {
            this.maxBurning = fuelTime;
            this.zero = burning.zero();
        }
        return burning.withValue(value, context);
    }

    @Override
    public Burning getBurning(BurningContext context) {
        context = new Context(context, this.operator);
        return this.zero.withValue(this.currentBurning, context);
    }

    @Override
    public boolean isBurning() {
        return this.currentBurning > 0;
    }

    public record Snapshot(int currentBurning, int maxBurning, Burning zero) {
    }

    private static final class Context
    implements BurningContext {
        private final BurningContext source;
        private final IntUnaryOperator operator;

        public Context(BurningContext source, IntUnaryOperator operator) {
            this.source = source;
            this.operator = operator;
        }

        @Override
        public boolean isFuel(class_1799 itemStack) {
            return this.source.isFuel(itemStack);
        }

        @Override
        public boolean isFuel(class_1792 item) {
            return this.source.isFuel(item);
        }

        @Override
        public int burnDuration(class_1799 itemStack) {
            return this.operator.applyAsInt(this.source.burnDuration(itemStack));
        }

        @Override
        public int burnDuration(class_1792 item) {
            return this.operator.applyAsInt(this.source.burnDuration(item));
        }
    }
}

