/*
 * Decompiled with CFR 0.152.
 */
package niv.burning.impl;

import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2586;
import niv.burning.api.Burning;
import niv.burning.api.BurningContext;
import niv.burning.api.BurningStorage;
import niv.burning.api.base.BurningStorageBlockEntity;
import niv.burning.impl.DynamicBurningStorageProvider;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DynamicBurningStorage
extends SnapshotParticipant<Snapshot>
implements BurningStorage {
    private final DynamicBurningStorageProvider provider;
    private final class_2586 target;
    private Burning zero;

    DynamicBurningStorage(DynamicBurningStorageProvider provider, class_2586 target) {
        this.provider = provider;
        this.target = target;
        this.zero = Burning.MIN_VALUE;
    }

    private double burning() {
        return this.provider.litTime.get(this.target);
    }

    private void burning(double value) {
        this.provider.litTime.set(this.target, value);
    }

    private double maxBurning() {
        return this.provider.litDuration.get(this.target);
    }

    private void maxBurning(double value) {
        this.provider.litDuration.set(this.target, value);
    }

    @Override
    public Burning insert(Burning burning, BurningContext context, TransactionContext transaction) {
        double currentBurning = this.burning();
        double maxBurning = this.maxBurning();
        int fuelTime = burning.getBurnDuration(context);
        double value = Math.min(Math.max(maxBurning, (double)fuelTime) - currentBurning, burning.getValue(context));
        this.updateSnapshots(transaction);
        this.burning(currentBurning += value);
        if (maxBurning > (double)fuelTime && currentBurning <= (double)fuelTime || currentBurning > maxBurning) {
            this.maxBurning(fuelTime);
            this.zero = burning.zero();
        }
        return burning.withValue((int)value, context);
    }

    @Override
    public boolean supportsExtraction() {
        return false;
    }

    @Override
    public Burning extract(Burning burning, BurningContext context, TransactionContext transaction) {
        return burning.zero();
    }

    @Override
    public Burning getBurning(BurningContext context) {
        double burning = this.burning();
        if (burning > (double)this.zero.getBurnDuration(context)) {
            this.zero = Burning.MIN_VALUE;
        }
        return this.zero.withValue((int)burning, context);
    }

    @Override
    public boolean isBurning() {
        return this.burning() > 0.0;
    }

    protected Snapshot createSnapshot() {
        return new Snapshot(this.burning(), this.maxBurning(), this.zero);
    }

    protected void readSnapshot(Snapshot snapshot) {
        this.burning(snapshot.burning);
        this.maxBurning(snapshot.maxBurning);
        this.zero = snapshot.zero;
    }

    protected void onFinalCommit() {
        BurningStorageBlockEntity.tryUpdateLitProperty(this.target, this);
        this.target.method_5431();
    }

    public record Snapshot(double burning, double maxBurning, Burning zero) {
    }
}

