/*
 * Decompiled with CFR 0.152.
 */
package niv.burning.impl;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Function;

abstract class DynamicField {
    private static final ImmutableMap<Class<?>, Function<Field, ? extends DynamicField>> MAP = ImmutableMap.builderWithExpectedSize((int)8).put(Integer.TYPE, IntegerField::new).put(Integer.class, IntegerField::new).put(Long.TYPE, LongField::new).put(Long.class, LongField::new).put(Float.TYPE, FloatField::new).put(Float.class, FloatField::new).put(Double.TYPE, DoubleField::new).put(Double.class, DoubleField::new).build();
    protected final Field field;

    private DynamicField(Field field) {
        this.field = field;
    }

    final String getName() {
        return this.field.getName();
    }

    abstract Double get(Object var1);

    abstract void set(Object var1, Double var2);

    static final Optional<DynamicField> of(Field field) {
        return Optional.ofNullable((Function)MAP.getOrDefault(field.getType(), null)).map(constructor -> (DynamicField)constructor.apply(field));
    }

    private static final class DoubleField
    extends DynamicField {
        private DoubleField(Field field) {
            super(field);
        }

        @Override
        Double get(Object target) {
            try {
                return this.field.getDouble(target);
            }
            catch (NullPointerException ex) {
                return 0.0;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        void set(Object target, Double value) {
            try {
                this.field.setDouble(target, value);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static final class FloatField
    extends DynamicField {
        private FloatField(Field field) {
            super(field);
        }

        @Override
        Double get(Object target) {
            try {
                return this.field.getFloat(target);
            }
            catch (NullPointerException ex) {
                return 0.0;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        void set(Object target, Double value) {
            try {
                this.field.setFloat(target, value.floatValue());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static final class LongField
    extends DynamicField {
        private LongField(Field field) {
            super(field);
        }

        @Override
        Double get(Object target) {
            try {
                return this.field.getLong(target);
            }
            catch (NullPointerException ex) {
                return 0.0;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        void set(Object target, Double value) {
            try {
                this.field.setLong(target, value.longValue());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static final class IntegerField
    extends DynamicField {
        private IntegerField(Field field) {
            super(field);
        }

        @Override
        Double get(Object target) {
            try {
                return this.field.getInt(target);
            }
            catch (NullPointerException ex) {
                return 0.0;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        void set(Object target, Double value) {
            try {
                this.field.setInt(target, value.intValue());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

